% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heap.R
\name{heap}
\alias{heap}
\title{Heap's algorithm for enumerating permutations}
\usage{
heap(ind)
}
\arguments{
\item{ind}{A permuted vector of the integers $\{1,\ldots,n\}$ for some $n$. For all terms in the sequence other than the first, the input is vector is expected to include a `counter' attribute, which is needed by the algorithm to keep track of its position.}
}
\value{
The next permutation in the Heap sequence, accompanied by an updated counter attribute.
}
\description{
Computes the next permutation in a sequence that eventually includes, without repetition, all possible permutations. There are many R packages with functions for computing all permutations, most of which are more highly optimized than \code{heap}. The value of the current implementation is its relative transparency and `hack-ability', which helps us use it for the brute-force enumeration of expected permutation matrices.
}
\examples{
n<-4
permi<-1:n
allperms<-c()
for(i in 1:factorial(n)){
  allperms<-rbind(allperms,permi)
  permi<-heap(permi)
}
allperms
}
