% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_columns.R
\name{add_columns}
\alias{add_columns}
\title{Add columns to data.frame.}
\usage{
add_columns(x, y, by = NULL, ignore_duplicates = FALSE, ...)
}
\arguments{
\item{x}{data.frame to be joined with \code{y}.}

\item{y}{data.frame.}

\item{by}{character vector or NULL(default) or 1. Names of common variables
in the \code{x} and \code{y} by which we will attach \code{y} to
\code{x}. If it is NULL then common names will be used. If it is equals
to 1 then we will use the first column from both dataframes. To add columns
by different variables on \code{x} and \code{y} use a named vector.
For example, \code{by = c("a" = "b")} will match x.a to y.b.}

\item{ignore_duplicates}{logical Should we ignore duplicates in the \code{by}
variables in the \code{y}? If it is TRUE than first occurrence of duplicated
key will be used.}

\item{...}{arguments for further methods}
}
\value{
data.frame
}
\description{
\code{add_columns} inspired by MATCH FILES (Add
variables...) from SPSS Statistics. It works similar to SQL left join but
number of cases in the left part always remain the same. If there are
duplicated keys in the \code{y} then error will be raised by default.
}
\examples{

# example for 'add_columns' from base 'merge'
authors = data.frame(
    surname = c("Tukey", "Venables", "Tierney", "Ripley", "McNeil"),
    nationality = c("US", "Australia", "US", "UK", "Australia"),
    deceased = c("yes", rep("no", 4))
)

books = data.frame(
    surname = c("Tukey", "Venables", "Tierney",
                "Ripley", "Ripley", "McNeil", "R Core"),
    title = c("Exploratory Data Analysis",
              "Modern Applied Statistics ...",
              "LISP-STAT",
              "Spatial Statistics", "Stochastic Simulation",
              "Interactive Data Analysis",
              "An Introduction to R")
)

add_columns(books, authors)

}
