% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{modify}
\alias{modify}
\alias{compute}
\alias{modify_if}
\alias{do_if}
\alias{calculate}
\alias{use_labels}
\alias{calc}
\alias{\%calc\%}
\alias{\%use_labels\%}
\alias{\%calculate\%}
\title{Modify data.frame/modify subset of the data.frame}
\usage{
modify(data, expr)

compute(data, expr)

modify_if(data, cond, expr)

do_if(data, cond, expr)

calculate(data, expr, use_labels = FALSE)

use_labels(data, expr)

calc(data, expr, use_labels = FALSE)

data \%calc\% expr

data \%use_labels\% expr

data \%calculate\% expr
}
\arguments{
\item{data}{data.frame/list of data.frames. If \code{data} is list of
data.frames then expression \code{expr} will be evaluated inside each
data.frame separately.}

\item{expr}{expression that should be evaluated in the context of data.frame \code{data}}

\item{cond}{logical vector or expression. Expression will be evaluated in the context of the data.}

\item{use_labels}{logical. Experimental feature. If it equals to \code{TRUE} 
then we will try to replace variable names with labels. So many base R
functions which show variable names will show labels.}
}
\value{
\code{compute} and \code{do_if} functions return modified 
  data.frame/list of modified data.frames, \code{calculate} returns value of
  the evaluated expression/list of values.
}
\description{
\itemize{
\item{{\code{compute}}{ evaluates expression \code{expr} in the context of data.frame 
\code{data} and return original data possibly modified. It works similar to
\code{\link[base]{within}} in base R but try to return new variables in order
of their occurrence in the expression and make available
full-featured \code{\%to\%} and \code{.N} in the expressions. See \link{vars}.}}
\item{{\code{calculate}}{ evaluates expression \code{expr} in the context of 
data.frame \code{data} and return value of the evaluated expression. It works
similar to \code{\link[base]{with}} in base R but make available 
full-featured \code{\%to\%} and \code{.N} in the expressions. See 
\link{vars}. Function \code{use_labels} is shortcut for \code{calculate} with
argument \code{use_labels} set to \code{TRUE}. When \code{use_labels} is TRUE
there is a special shortcut for entire data.frame - \code{..data}.}}
\item{{\code{do_if}}{ modifies only rows for which \code{cond} equals to
TRUE. Other rows remain unchanged. Newly created variables also will have
values only in rows for which \code{cond} have TRUE. There will be NA's in
other rows. This function tries to mimic SPSS "DO IF(). ... END IF."
statement.}}
}
There is a special constant \code{.N} which equals to number of cases in 
\code{data} for usage in expression inside \code{compute}/\code{calculate}. 
Inside \code{do_if} \code{.N} gives number of rows which will be affected by 
expressions. For parametrization (variable substitution) see \link{..} or 
examples. Sometimes it is useful to create new empty variable inside compute.
You can use \code{.new_var} function for this task. This function creates
variable of length \code{.N} filled with NA. See examples.
\code{modify} is an alias for \code{compute}, \code{modify_if} is
an alias for \code{do_if} and \code{calc} is an alias for \code{calculate}.
}
\examples{
dfs = data.frame(
    test = 1:5,
    a = rep(10, 5),
    b_1 = rep(11, 5),
    b_2 = rep(12, 5),
    b_3 = rep(13, 5),
    b_4 = rep(14, 5),
    b_5 = rep(15, 5) 
)


# compute sum of b* variables and attach it to 'dfs'
compute(dfs, {
    b_total = sum_row(b_1 \%to\% b_5)
    var_lab(b_total) = "Sum of b"
    random_numbers = runif(.N) # .N usage
})

# calculate sum of b* variables and return it
calculate(dfs, sum_row(b_1 \%to\% b_5))


# set values to existing/new variables
compute(dfs, {
    (b_1 \%to\% b_5) \%into\% subst('new_b`1:5`')
})

# .new_var usage
compute(dfs, {
    new_var = .new_var()
    new_var[1] = 1 # this is not possible without preliminary variable creation
})

# conditional modification
do_if(dfs, test \%in\% 2:4, {
    a = a + 1    
    b_total = sum_row(b_1 \%to\% b_5)
    random_numbers = runif(.N) # .N usage
})


# variable substitution
name1 = "a"
name2 = "new_var"

# example with short notation but it can be applied only for simple cases - 
# when 'name' is vector of length 1
compute(dfs, {
     ..$name2 = ..$name1*2    
})

compute(dfs, {
     for(name1 in paste0("b_", 1:5)){
         name2 = paste0("new_", name1) 
         ..$name2 = ..$name1*2 
     }
     rm(name1, name2) # we don't need this variables as columns in 'dfs'
})

# square brackets notation
compute(dfs, {
     ..[(name2)] = ..[(name1)]*2  
})

compute(dfs, {
     for(name1 in paste0("b_", 1:5)){
         ..[paste0("new_", name1)] = ..$name1*2 
     }
     rm(name1) # we don't need this variable as column in 'dfs'
})

# '..$' doesn't work for case below so we need to use square brackets form
name1 = paste0("b_", 1:5)
name2 = paste0("new_", name1)
compute(dfs, {
     for(i in 1:5){
         ..[name2[i]] = ..[name1[i]]*3
     }
     rm(i) # we don't need this variable as column in 'dfs'
})

# 'use_labels' examples. Utilization of labels in base R.
data(mtcars)
mtcars = apply_labels(mtcars,
                      mpg = "Miles/(US) gallon",
                      cyl = "Number of cylinders",
                      disp = "Displacement (cu.in.)",
                      hp = "Gross horsepower",
                      drat = "Rear axle ratio",
                      wt = "Weight (lb/1000)",
                      qsec = "1/4 mile time",
                      vs = "Engine",
                      vs = c("V-engine" = 0,
                             "Straight engine" = 1),
                      am = "Transmission",
                      am = c("Automatic" = 0,
                             "Manual"=1),
                      gear = "Number of forward gears",
                      carb = "Number of carburetors"
)

use_labels(mtcars, table(am, vs))

\dontrun{
use_labels(mtcars, plot(mpg, hp))
}

mtcars \%>\% 
       use_labels(lm(mpg ~ disp + hp + wt)) \%>\% 
       summary()

}
