/*
 * Decompiled with CFR 0.152.
 */
package org.extratrees;

public class Matrix {
    public double[] v;
    public int ncols;
    public int nrows;

    public Matrix(int n, int n2) {
        this(new double[n * n2], n, n2);
    }

    public Matrix(double[] dArray, int n, int n2) {
        if (dArray.length != n * n2) {
            throw new IllegalArgumentException("Length of v (" + dArray.length + ") is not equal to nrows*ncols (" + n + "*" + n2 + ")");
        }
        this.v = dArray;
        this.nrows = n;
        this.ncols = n2;
    }

    public void set(int n, int n2, double d) {
        this.v[n + n2 * this.nrows] = d;
    }

    public double get(int n, int n2) {
        return this.v[n + n2 * this.nrows];
    }

    public void copyRow(int n, double[] dArray) {
        for (int i = 0; i < this.ncols; ++i) {
            dArray[i] = this.get(n, i);
        }
    }

    public void square() {
        for (int i = 0; i < this.v.length; ++i) {
            int n = i;
            this.v[n] = this.v[n] * this.v[i];
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                stringBuilder.append(String.format("%1.4f", this.get(i, j)));
                stringBuilder.append(" ");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[40];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = i + 1;
        }
        Matrix matrix = new Matrix(dArray, 10, 4);
        System.out.println(matrix);
    }
}

