% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageOxygen.R
\name{hill.adapt}
\alias{hill.adapt}
\title{Compute the extreme quantile procedure}
\usage{
hill.adapt(X, weights = rep(1, length(X)), initprop = 1/10, gridlen = 100,
  r1 = 1/4, r2 = 1/20, CritVal = 10, plot = F)
}
\arguments{
\item{X}{a numeric vector of data values.}

\item{weights}{a numeric vector of weigths associated to the vector \eqn{X}.}

\item{initprop}{the initial proportion at which we begin to test the model.}

\item{gridlen}{the length of the grid for which the test is done.}

\item{r1}{a proportion value of the data from the right that we skip in the test statistic.}

\item{r2}{a proportion value of the data from the left that we skip in the test statistic.}

\item{CritVal}{the critical value assiociated to the weights.}

\item{plot}{If \code{TRUE}, the results are plotted.}
}
\value{
\item{Xsort}{the sorted vector of the data.}
\item{sortweights}{the weights associated to Xsort.}
\item{wh}{the weighted Hill estimator associated to X (output of the function hill).}
\item{TestingGrid}{the grid used for the statistic test.}
\item{TS,TS1,TS.max,TS1.max}{respectively the test statistic, the likelihood ratio test, the maximum of the test statistic and the maximum likelihood ratio test.}
\item{Paretodata}{logical: if TRUE the distribution of the data is a Pareto distribution.}
\item{Paretotail}{logical: if TRUE a Pareto tail was detected.}
\item{madapt}{the first indice of the TestingGrid for which the test statistic exceeds the critical value.}
\item{kadapt}{the adaptive indice of the threshold.}
\item{kadapt.maxlik}{the maximum likelihood corresponding to the adaptive threshold in the selected testing grid.}
\item{hadapt}{the adaptive weighted parameter of the Pareto distribution after the threshold.}
\item{Xadapt}{the adaptive threshold.}
}
\description{
Compute the extreme quantile procedure
}
\details{
Given a vector of data and assiociated weights, this function compute the adaptive procedure described in Grama and Spokoiny (2008) and Durrieu et al. (2015).

We suppose that the data are in the domain of attraction of the Frechet-Pareto type. Otherwise, the procedure will not work.
}
\examples{

x <- abs(rcauchy(100))
HH <- hill.adapt(x, weights=rep(1, length(x)), initprop = 0.1,
               gridlen = 100 , r1 = 0.25, r2 = 0.05, CritVal=10,plot=TRUE)
#the critical value 10 is assiociated to the rectangular kernel.
HH$Xadapt # is the adaptive threshold
HH$hadapt # is the adaptive parameter of the Pareto distribution

}
\author{
Ion Grama
}
\references{
Grama, I. and Spokoiny, V. (2008). Statistics of extremes by oracle estimation. Ann. of Statist., 36, 1619-1648.

Durrieu, G. and Grama, I. and Pham, Q. and Tricot, J.- M (2015). Nonparametric adaptive estimator of extreme conditional tail probabilities quantiles. Extremes, 18, 437-478.
}

