% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixation_VTI.R
\name{fixation_VTI}
\alias{fixation_VTI}
\title{Fixation detection using a velocity threshold identification method}
\usage{
fixation_VTI(
  data,
  sample_rate = NULL,
  threshold = 100,
  min_dur = 150,
  min_dur_sac = 20,
  disp_tol = 100,
  smooth = FALSE,
  progress = TRUE,
  participant_ID = "participant_ID"
)
}
\arguments{
\item{data}{A dataframe with raw data (time, x, y, trial) for one participant}

\item{sample_rate}{sample rate of the eye-tracker. If default of NULL, then it will be computed from the timestamp data and the number of samples}

\item{threshold}{velocity threshold (degrees of VA / sec) to be used for identifying saccades.}

\item{min_dur}{Minimum duration (in milliseconds) of period over which fixations are assessed}

\item{min_dur_sac}{Minimum duration (in milliseconds) for saccades to be determined}

\item{disp_tol}{Maximum tolerance (in pixels) for the dispersion of values allowed over fixation period}

\item{smooth}{include a call to eyetools::smoother on each trial}

\item{progress}{Display a progress bar}

\item{participant_ID}{the variable that determines the participant identifier. If no column present, assumes a single participant}
}
\value{
a dataframe containing each detected fixation by trial, with mean x/y position in pixel, start and end times, and duration.
}
\description{
Determine fixations by assessing the velocity of eye-movements, using a method that is similar to that proposed by Salvucci & Goldberg (1996).
Applies the algorithm used in VTI_saccade and removes the identified saccades before assessing whether separated fixations are outside of the dispersion tolerance.
If they are outside of this tolerance, the fixation is treated as a new fixation regardless of the length of saccade separating them.
Compared to fixation_dispersion(), fixation_VTI() is more conservative in determining a fixation as smaller saccades are discounted and the resulting data is
treated as a continued fixation (assuming it is within the pixel tolerance set by disp_tol).
Returns a summary of the fixations found per trial, including start and end coordinates, timing, duration, mean velocity, and peak velocity.
}
\details{
It can take either single participant data or multiple participants where there is a variable for unique participant identification.
The function looks for an identifier named \code{participant_ID} by default and will treat this as multiple-participant data as default,
if not it is handled as single participant data, or the participant_ID needs to be specified
}
\examples{
\donttest{
data <- combine_eyes(HCL)
data <- interpolate(data, participant_ID = "pNum")
fixation_VTI(data[data$pNum == 119,], participant_ID = "pNum")
}

}
\references{
Salvucci, D. D., & Goldberg, J. H. (2000). Identifying fixations and saccades in eye-tracking protocols. Proceedings of the Symposium on Eye Tracking Research & Applications - ETRA '00, 71–78.
}
