% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_default_params.R
\name{set_default_params}
\alias{set_default_params}
\title{Set default parameters}
\usage{
set_default_params(params)
}
\arguments{
\item{params}{List of parameters.}
}
\description{
Create variables with the given values only if these variables do not currently
exist.
}
\details{
Sometimes it may be useful to define a variable only it hasn't been defined yet.
One example where this can be useful is when you have an Rmd script that 
uses some variables and you want to be able to use custom values for these
variables, but also give them a default value in the script in case they are
not set beforehand.
}
\examples{
exists("foo")
exists("bar")
foo <- 5
set_default_params(list(foo = 10, bar = 20))
print(foo)
print(bar)
}

