test_that("(Scaled) GED function has proper 1st, 2nd and 3rd noncentralized moments", {
  # 1st moment
  expect_equal(
    vapply(
      X = seq(1.5, 2.5, by = 0.05),
      FUN = function(.x) {
        integrate(function(x, .x, dfun) {x * dfun(x, shape = .x)}, lower = -Inf, upper = Inf, .x = .x, dfun = pdf_ged_v1)[[1]]
      },
      FUN.VALUE = numeric(1)
    ),
    rep(0, 21)
  )
  # 2nd moment
  expect_equal(
    vapply(
      X = seq(1.5, 2.5, by = 0.05),
      FUN = function(.x) {
        integrate(function(x, .x, dfun) {x^2 * dfun(x, shape = .x)}, lower = -Inf, upper = Inf, .x = .x, dfun = pdf_ged_v1)[[1]]
      },
      FUN.VALUE = numeric(1)
    ),
    rep(1, 21)
  )
  # 3rd moment
  expect_equal(
    vapply(
      X = seq(1.5, 2.5, by = 0.05),
      FUN = function(.x) {
        integrate(function(x, .x, dfun) {x^3 * dfun(x, shape = .x)}, lower = -Inf, upper = Inf, .x = .x, dfun = pdf_ged_v1)[[1]]
      },
      FUN.VALUE = numeric(1)
    ),
    rep(0, 21)
  )
})
test_that("(Scaled) GED function returns values as expected", {
  # Check values for different dfs
  expect_equal(
    lapply(
      X = seq(1.5, 2.5, by = 0.05),
      FUN = function(.x) {
        c(pdf_ged_v1(c(-1.96, -1, -0.5, -0.25, 0, 0.25, 0.5, 1, 1.96), .x))
      }
    ),
list(c(0.0534844079770442, 0.214587162399423, 0.359134124530429,
0.430853799603165, 0.475966652407149, 0.430853799603165, 0.359134124530429,
0.214587162399423, 0.0534844079770442), c(0.0541353456193683,
0.217879254426337, 0.358825092084356, 0.425477638630065, 0.464784809911769,
0.425477638630065, 0.358825092084356, 0.217879254426337, 0.0541353456193683
), c(0.0547470173848284, 0.221031323301431, 0.358387589314973,
0.420333356017909, 0.454651477416219, 0.420333356017909, 0.358387589314973,
0.221031323301431, 0.0547470173848284), c(0.0553214379904933,
0.224050505542552, 0.357840040718377, 0.415415007500004, 0.445433581755015,
0.415415007500004, 0.357840040718377, 0.224050505542552, 0.0553214379904933
), c(0.0558604750959645, 0.226943445737386, 0.357198624563268,
0.410715619172665, 0.437019074725502, 0.410715619172665, 0.357198624563268,
0.226943445737386, 0.0558604750959645), c(0.0563658634472556,
0.229716342893635, 0.356477553668718, 0.406227526132718, 0.429313006102702,
0.406227526132718, 0.356477553668718, 0.229716342893635, 0.0563658634472556
), c(0.0568392173549524, 0.232374991261211, 0.355689318464057,
0.401942633716071, 0.422234434661957, 0.401942633716071, 0.355689318464057,
0.232374991261211, 0.0568392173549524), c(0.0572820417357533,
0.234924816399267, 0.354844897850602, 0.397852618090383, 0.415713977693324,
0.397852618090383, 0.354844897850602, 0.234924816399267, 0.0572820417357533
), c(0.0576957419110385, 0.237370907140159, 0.353953942504029,
0.393949079291755, 0.409691851577671, 0.393949079291755, 0.353953942504029,
0.237370907140159, 0.0576957419110385), c(0.0580816323266412,
0.239718044002153, 0.353024934527872, 0.390223656957621, 0.40411629336471,
0.390223656957621, 0.353024934527872, 0.239718044002153, 0.0580816323266412
), c(0.0584409443334515, 0.241970724519143, 0.3520653267643,
0.386668116802849, 0.398942280401433, 0.386668116802849, 0.3520653267643,
0.241970724519143, 0.0584409443334515), c(0.0587748331479621,
0.244133185885981, 0.35108166456546, 0.383274414167238, 0.394130484927095,
0.383274414167238, 0.35108166456546, 0.244133185885981, 0.0587748331479621
), c(0.0590843840946876, 0.246209425259641, 0.350079692408785,
0.380034739619249, 0.3896464152536, 0.380034739619249, 0.350079692408785,
0.246209425259641, 0.0590843840946876), c(0.0593706182179428,
0.248203218007524, 0.349064447388018, 0.376941550548035, 0.38545970613,
0.376941550548035, 0.349064447388018, 0.248203218007524, 0.0593706182179428
), c(0.0596344973382975, 0.250118134152962, 0.348040341316381,
0.373987591848815, 0.381543529160348, 0.373987591848815, 0.348040341316381,
0.250118134152962, 0.0596344973382975), c(0.0598769286187373,
0.251957553233271, 0.347011232929495, 0.371165908155476, 0.377874100424404,
0.371165908155476, 0.347011232929495, 0.251957553233271, 0.0598769286187373
), c(0.060098768696837, 0.25372467775623, 0.345980491465476,
0.368469849560485, 0.374430267256504, 0.368469849560485, 0.345980491465476,
0.25372467775623, 0.060098768696837), c(0.0603008274318377, 0.255422545415934,
0.344951052721597, 0.365893072356071, 0.371193159842112, 0.365893072356071,
0.344951052721597, 0.255422545415934, 0.0603008274318377), c(0.0604838713091952,
0.257054040207701, 0.343925468535747, 0.363429536009014, 0.36814589616649,
0.363429536009014, 0.343925468535747, 0.257054040207701, 0.0604838713091952
), c(0.0606486265397563, 0.258621902563602, 0.342905950512147,
0.361073497326345, 0.365273331095827, 0.361073497326345, 0.342905950512147,
0.258621902563602, 0.0606486265397563), c(0.0607957818860857,
0.260128738614661, 0.341894408700984, 0.358819502566728, 0.362561842136644,
0.358819502566728, 0.341894408700984, 0.260128738614661, 0.0607957818860857
))
  )

  # Check symmetry once again numerically for different shape values
  expect_equal(
  lapply(
    X = seq(1.5, 2.5, by = 0.05),
    FUN = function(.x) {
      pdf_ged_v1(c(-1.96, -1, -0.5, -0.25, -0.1), shape = .x)
    }
  ),
  lapply(
    X = seq(1.5, 2.5, by = 0.05),
    FUN = function(.x) {
      pdf_ged_v1(c(1.96, 1, 0.5, 0.25, 0.1), shape = .x)
    }
  )
  )

})

#------------------------------------------------------

test_that("Check likelihood function for (scaled) GED", {
  expect_equal(
  lapply(
    X = seq(1.5, 2.5, by = 0.05),
    FUN = function(.x) {
      c(pdf_ged(c(-1.96, -1.5, -1, -0.5, -0.25, 0, 0.25, 0.5, 1, 1.5, 1.96),
              mu = rep(0.05, 11), sigt = rep(0.5, 11), shape = .x))
    }
  ),
list(c(0.00154895897732756, 0.0123097112516272, 0.084284146917348,
0.379718071914802, 0.657374569691663, 0.928252016434636, 0.778182678768618,
0.482180647366745, 0.118171955270503, 0.0186213977146087, 0.00248617500300954
), c(0.00133404547972191, 0.011690744938363, 0.0849414398185544,
0.386245189377876, 0.659502059360078, 0.909930926411605, 0.774050380596167,
0.488452241620132, 0.119796097587859, 0.0179672244509941, 0.00219479073109464
), c(0.00114088137638818, 0.0110738634189903, 0.0855253895408651,
0.392539849724039, 0.661278523371576, 0.89297798371551, 0.769850336578775,
0.494396653068764, 0.121339739943095, 0.0173004387699097, 0.00192633869284427
), c(0.000968659794883438, 0.010462258409369, 0.0860398401036735,
0.398613051687911, 0.662739400132192, 0.877266971419166, 0.765612548152486,
0.500032614913614, 0.122807034509103, 0.0166247676775429, 0.0016807316205804
), c(0.00081635225411112, 0.00985880275785687, 0.086488365806863,
0.4044750263614, 0.663916581947782, 0.862684939888662, 0.761362079173815,
0.505377532177673, 0.124201827403683, 0.0159436632187095, 0.0014575801431411
), c(0.000682758458737327, 0.00926606610895124, 0.0868742970527188,
0.410135311728696, 0.664838800226667, 0.849130717501176, 0.757119802039183,
0.510447604082781, 0.125527688202295, 0.01526031755265, 0.00125623636573373
), c(0.000566553004458961, 0.00868632938247678, 0.0872007431374649,
0.415602818197044, 0.665531963865984, 0.836513583915715, 0.752903028156379,
0.515257932173954, 0.126787935968416, 0.0145776762486302, 0.00107583621459289
), c(0.000466328549836359, 0.00812159835222854, 0.0874706124282378,
0.420885886383042, 0.666019457231842, 0.824752092988884, 0.748726041705451,
0.519822616164455, 0.127985662280901, 0.0138984501042688, 0.000915340242646122
), c(0.000380635048011988, 0.00757361656148202, 0.08768663027696,
0.425992338217963, 0.666322403161089, 0.813773031317796, 0.744600552325208,
0.524154839166644, 0.129123751663567, 0.0132251257453566, 0.000773572562222354
), c(0.000308014694040991, 0.0070438777725505, 0.0878513549691093,
0.430929522272463, 0.66645989559613, 0.803510498390116, 0.740536079672732,
0.528266943717835, 0.130204899760516, 0.0125599752288686, 0.000649257560605249
), c(0.000247032326682047, 0.00653363811239984, 0.0879671919608544,
0.435704354065101, 0.666449205783599, 0.793905094954024, 0.736540280606647,
0.53217049979751, 0.131231629549353, 0.0119050648395517, 0.000541054062923042
), c(0.000196301122526627, 0.00604392804527379, 0.0880364066208271,
0.440323352005578, 0.666305965398148, 0.784903207188718, 0.732619227944631,
0.535876365854673, 0.132206305841496, 0.011262263243795, 0.000447586633088366
), c(0.00015450352986271, 0.00557556427560728, 0.0880611356616418,
0.444792669528525, 0.666044329474631, 0.77645637537197, 0.728777648266018,
0.539394743715605, 0.133131148282808, 0.0106332491415683, 0.000367473745425425
), c(0.000120407503849774, 0.00512916165965104, 0.0880433974200895,
0.449118123893842, 0.665677121629261, 0.768520736890816, 0.725019125010636,
0.542735228117629, 0.13400824303755, 0.0100195185373488, 0.000299352614952725
), c(9.28782174552886e-05, 0.00470514518177799, 0.0879851011228673,
0.45330522206239, 0.665215963710066, 0.761056534557823, 0.721346272116826,
0.545906851509712, 0.134839553313176, 0.00942239173355997, 0.000241900540287735
), c(7.08855283599813e-05, 0.00430376203108516, 0.0878880552560478,
0.457359183999081, 0.664671391728517, 0.754027682241263, 0.717760882605946,
0.548918124672236, 0.135626928861956, 0.00884302013467797, 0.000193852686682253
), c(5.35075753548677e-05, 0.00392509379542998, 0.0877539751406758,
0.461284963707368, 0.664052959678865, 0.747401380775078, 0.714264055826286,
0.551777073633454, 0.136372114577148, 0.00828239293643772, 0.000154016314376219
), c(3.99309541038238e-05, 0.00356906877330791, 0.0875844898034316,
0.465087268258359, 0.663369332642481, 0.741147777977416, 0.710856306490824,
0.554491273296609, 0.137076758285931, 0.00774134376221429, 0.000121281535715501
), c(2.94479780865508e-05, 0.00323547438890627, 0.0873811482198215,
0.468770575043008, 0.662628370395446, 0.73523966737549, 0.707537658160193,
0.557067878137647, 0.137742417828069, 0.00722055729742652, 9.46287597651835e-05
), c(2.14515639184828e-05, 0.00292396968222241, 0.0871454249975486,
0.472339147446252, 0.661837202584042, 0.729652220914477, 0.704307723417891,
0.559513650287331, 0.138370567497949, 0.00672057596253511, 7.31330520955936e-05
), c(1.54282903382132e-05, 0.00263409783430873, 0.0868787255592963,
0.47579704911653, 0.661002296400643, 0.724362751525935, 0.70116577264557,
0.561834985272062, 0.13896260391795, 0.00624180665574425, 5.59656970120547e-05
))
)
})
