% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fHMM_controls.R
\name{set_controls}
\alias{set_controls}
\alias{validate_controls}
\alias{print.fHMM_controls}
\alias{summary.fHMM_controls}
\title{Define and validate model specifications}
\usage{
set_controls(
  controls = list(),
  hierarchy = FALSE,
  states = if (!hierarchy) 2 else c(2, 2),
  sdds = if (!hierarchy) "normal" else c("normal", "normal"),
  horizon = if (!hierarchy) 100 else c(100, 30),
  period = if (hierarchy && is.na(horizon[2])) "m" else NA,
  data = NA,
  file = NA,
  date_column = if (!hierarchy) "Date" else c("Date", "Date"),
  data_column = if (!hierarchy) "Close" else c("Close", "Close"),
  from = NA,
  to = NA,
  logreturns = if (!hierarchy) FALSE else c(FALSE, FALSE),
  merge = function(x) mean(x),
  fit = list(),
  runs = 10,
  origin = FALSE,
  accept = 1:3,
  gradtol = 0.01,
  iterlim = 100,
  print.level = 0,
  steptol = 0.01
)

validate_controls(controls)

\method{print}{fHMM_controls}(x, ...)

\method{summary}{fHMM_controls}(object, ...)
}
\arguments{
\item{controls}{Either a \code{list} or an object of class \code{fHMM_controls}.

The \code{list} can contain the following elements, which are described
in more detail below:
\itemize{
\item \code{hierarchy}, defines an hierarchical HMM,
\item \code{states}, defines the number of states,
\item \code{sdds}, defines the state-dependent distributions,
\item \code{horizon}, defines the time horizon,
\item \code{period}, defines a flexible, periodic fine-scale time horizon,
\item \code{data}, a \code{list} of controls that define the data,
\item \code{fit}, a \code{list} of controls that define the model fitting
}
Either none, all, or selected elements can be specified.

Unspecified parameters are set to their default values.

Important: Specifications in \code{controls} always override individual
specifications.}

\item{hierarchy}{A \code{logical}, set to \code{TRUE} for an hierarchical HMM.

If \code{hierarchy = TRUE}, some of the other controls must be specified for
the coarse-scale and the fine-scale layer.

By default, \code{hierarchy = FALSE}.}

\item{states}{An \code{integer}, the number of states of the underlying Markov chain.

If \code{hierarchy = TRUE}, \code{states} must be a \code{vector} of length
2. The first entry corresponds to the coarse-scale layer, while the second
entry corresponds to the fine-scale layer.

By default, \code{states = 2} if \code{hierarchy = FALSE} and
\code{states = c(2, 2)} if \code{hierarchy = TRUE}.}

\item{sdds}{A \code{character}, specifying the state-dependent distribution. One of
\itemize{
\item \code{"normal"} (the normal distribution),
\item \code{"lognormal"} (the log-normal distribution),
\item \code{"t"} (the t-distribution),
\item \code{"gamma"} (the gamma distribution),
\item \code{"poisson"} (the Poisson distribution).
}

The distribution parameters, i.e. the
\itemize{
\item mean \code{mu},
\item standard deviation \code{sigma} (not for the Poisson distribution),
\item degrees of freedom \code{df} (only for the t-distribution),
}
can be fixed via, e.g., \code{"t(df = 1)"} or
\code{"gamma(mu = 0, sigma = 1)"}.
To fix different values of a parameter for different states, separate by
"|", e.g. \code{"poisson(mu = 1|2|3)"}.

If \code{hierarchy = TRUE}, \code{sdds} must be a \code{vector} of length 2.
The first entry corresponds to the coarse-scale layer, while the second entry
corresponds to the fine-scale layer.

By default, \code{sdds = "normal"} if \code{hierarchy = FALSE} and
\code{sdds = c("normal", "normal")} if \code{hierarchy = TRUE}.}

\item{horizon}{A \code{numeric}, specifying the length of the time horizon.

If \code{hierarchy = TRUE}, \code{horizon} must be a \code{vector} of length
2. The first entry corresponds to the coarse-scale layer, while the second
entry corresponds to the fine-scale layer.

By default, \code{horizon = 100} if \code{hierarchy = FALSE} and
\code{horizon = c(100, 30)} if \code{hierarchy = TRUE}.

If \code{data} is specified (i.e., not \code{NA}), the first entry of
\code{horizon} is ignored and the (coarse-scale) time horizon is defined by
available data.}

\item{period}{Only relevant if \code{hierarchy = TRUE} and \code{horizon[2] = NA}.

In this case, a \code{character} which specifies a flexible, periodic
fine-scale time horizon and can be one of
\itemize{
\item \code{"w"} for a week,
\item \code{"m"} for a month,
\item \code{"q"} for a quarter,
\item \code{"y"} for a year.
}

By default, \code{period = "m"} if \code{hierarchy = TRUE} and
\code{horizon[2] = NA}, and \code{NA} else.}

\item{data}{Either \code{NA}, in which case data is simulated (the default), or a
\code{list} of controls specifying the empirical data set.

The \code{list} can contain the following elements, which are described
in more detail below:
\itemize{
\item \code{file}, defines the data set,
\item \code{date_column}, defines the date column,
\item \code{data_column}, defines the data column,
\item \code{from}, defines a lower date limit,
\item \code{to}, defines an upper date limit,
\item \code{logreturns}, defines a data transformation to log-returns,
\item \code{merge}, defines the merging for coarse-scale observations.
}
Either none, all, or selected elements can be specified.

Unspecified parameters are set to their default values, see below.

Specifications in \code{data} override individual specifications.}

\item{file}{A \code{data.frame} with data and dates for modeling.

If \code{hierarchy = TRUE}, \code{file} can be a \code{list} of
length 2. The first entry is a \code{data.frame} and provides the data for
the coarse-scale layer, while the second entry corresponds to the fine-scale
layer. If \code{file} is a single \code{data.frame}, then the same
\code{data.frame} is used for both layers.

Alternatively, it can be a \code{character} (of length two), the path to a
.csv-file with financial data.}

\item{date_column}{A \code{character}, the name of the column in \code{file} with dates.

If \code{hierarchy = TRUE} and \code{file} is a \code{list} of two
\code{data.frame}s, \code{data_column} must be a \code{vector} of
length 2. The first entry corresponds to the coarse-scale layer, while the
second entry corresponds to the fine-scale layer.

By default, \code{date_column = "Date"}.}

\item{data_column}{A \code{character}, the name of the column in \code{file} with observations.

If \code{hierarchy = TRUE}, \code{data_column} must be a \code{vector} of
length 2. The first entry corresponds to the coarse-scale layer, while the
second entry corresponds to the fine-scale layer.

By default, \code{data_column = "Close"} if \code{hierarchy = FALSE} and
\code{data_column = c("Close", "Close")} if \code{hierarchy = TRUE}.}

\item{from}{A \code{character} of the format \code{"YYYY-MM-DD"}, setting a lower
date limit. No lower limit if \code{from = NA} (default).}

\item{to}{A \code{character} of the format \code{"YYYY-MM-DD"}, setting an upper
date limit. No lower limit if \code{to = NA} (default).}

\item{logreturns}{A \code{logical}, if \code{TRUE} the data is transformed to log-returns.

If \code{hierarchy = TRUE}, \code{logreturns} must be a \code{vector} of
length 2. The first entry corresponds to the coarse-scale layer, while the
second entry corresponds to the fine-scale layer.

By default, \code{logreturns = FALSE} if \code{hierarchy = FALSE} and
\code{logreturns = c(FALSE, FALSE)} if \code{hierarchy = TRUE}.}

\item{merge}{Only relevant if \code{hierarchy = TRUE}.

In this case, a \code{function}
which merges an input numeric vector of fine-scale data \code{x} into one
coarse-scale observation. For example,
\itemize{
\item \code{merge = function(x) mean(x)} (default) defines the mean of the
fine-scale data as the coarse-scale observation,
\item \code{merge = function(x) mean(abs(x))} for the mean of the
absolute values,
\item \code{merge = function(x) sum(abs(x))} for the sum of the
absolute values,
\item \code{merge = function(x) (tail(x, 1) - head(x, 1)) / head(x, 1)} for
the relative change of the first to the last fine-scale observation.
}}

\item{fit}{A \code{list} of controls specifying the model fitting.

The \code{list} can contain the following elements, which are described
in more detail below:
\itemize{
\item \code{runs}, defines the number of numerical optimization runs,
\item \code{origin}, defines initialization at the true parameters,
\item \code{accept}, defines the set of accepted optimization runs,
\item \code{gradtol}, defines the gradient tolerance,
\item \code{iterlim}, defines the iteration limit,
\item \code{print.level}, defines the level of printing,
\item \code{steptol}, defines the minimum allowable relative step length.
}
Either none, all, or selected elements can be specified.

Unspecified parameters are set to their default values, see below.

Specifications in \code{fit} override individual specifications.}

\item{runs}{An \code{integer}, setting the number of randomly initialized
optimization runs of the model likelihood from which the best one is selected
as the final model.

By default, \code{runs = 10}.}

\item{origin}{Only relevant for simulated data, i.e., if the \code{data} control is
\code{NA}.

In this case, a \code{logical}. If \code{origin = TRUE} the optimization is
initialized at the true parameter values.
This sets \code{run = 1} and \code{accept = 1:5}.

By default, \code{origin = FALSE}.}

\item{accept}{An \code{integer} (vector), specifying which optimization runs are
accepted based on the output code of \code{\link[stats]{nlm}}.

By default, \code{accept = 1:3}.}

\item{gradtol}{A positive \code{numeric} value, specifying the gradient tolerance, passed on
to \code{\link[stats]{nlm}}.

By default, \code{gradtol = 0.01}.}

\item{iterlim}{A positive \code{integer} value, specifying the iteration limit, passed on
to \code{\link[stats]{nlm}}.

By default, \code{iterlim = 100}.}

\item{print.level}{One of \code{0}, \code{1}, and \code{2} to control the verbosity of the
numerical likelihood optimization, passed on to \code{\link[stats]{nlm}}.

By default, \code{print.level = 0}.}

\item{steptol}{A positive \code{numeric} value, specifying the step tolerance, passed on
to \code{\link[stats]{nlm}}.

By default, \code{gradtol = 0.01}.}

\item{x, object}{An object of class \code{fHMM_controls}.}

\item{...}{Currently not used.}
}
\value{
An object of class \code{fHMM_controls}, which is a \code{list} that contains
model and estimation specifications.
}
\description{
This function defines and validates specifications for model estimation.
}
\details{
See the \href{https://loelschlaeger.de/fHMM/articles/}{vignette on controls}
for more details.
}
\examples{
# 2-state HMM with t-distributions for simulated data
set_controls(
  states = 2,   # the number of states
  sdds   = "t", # the state-dependent distribution
  runs   = 50   # the number of optimization runs
)

# 3-state HMM with normal distributions for the DAX closing prices
set_controls(
  states      = 3,
  sdds        = "normal",
  file        = download_data("^GDAXI"), # the data set
  date_column = "Date",                   # the column with the dates
  data_column = "Close"                   # the column with the data
)

# hierarchical HMM with Gamma and Poisson state distributions
set_controls(
  hierarchy = TRUE,                  # defines a hierarchy
  states    = c(3, 2),               # coarse scale and fine scale states
  sdds      = c("gamma", "poisson"), # distributions for both layers
  horizon   = c(100, NA),            # 100 simulated coarse-scale data points 
  period    = "m"                    # monthly simulated fine-scale data
)

# hierarchical HMM with data from .csv-file
set_controls(
  hierarchy = TRUE,
  states    = c(3, 2),
  sdds      = c("t", "t"),
  file      = c(               
    system.file("extdata", "dax.csv", package = "fHMM"),
    system.file("extdata", "vw.csv", package = "fHMM")
  ),
  date_column = c("Date", "Date"), 
  data_column = c("Close", "Close"),
  logreturns  = c(TRUE, TRUE)
)

}
