% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt.rank.R
\name{opt.rank}
\alias{opt.rank}
\title{Finds the optimal rank for non-negative matrix factorization (NMF)}
\usage{
opt.rank(Y, nruns = 50, algtype = "brunet")
}
\arguments{
\item{Y}{An input multivariate time series in matrix format, with variables organized in columns and time points in rows. All entries in Y must be positive.}

\item{nruns}{A positive integer with default value equal to 50. It is used to define the number of runs in the NMF function.}

\item{algtype}{A character string, which defines the algorithm to be used in the NMF function. By default it is set to "brunet". See the "Algorithms" section of
\code{\link[NMF]{nmf}} for more information on the available algorithms.}
}
\value{
A positive integer representing the optimal rank.
}
\description{
This function finds the optimal rank for non-negative matrix factorization (NMF).
}
\examples{
\donttest{
## Finding the optimal rank for an input data set "sim2" with the default settings
opt.rank(sim2, nruns = 4)
# [1] 2
}

}
\references{
"Factorized Binary Search: a novel technique for change point detection in multivariate high-dimensional time series networks", Ondrus et al.
(2021), <arXiv:2103.06347>.
}
\author{
Martin Ondrus, \email{mondrus@ualberta.ca}, Ivor Cribben, \email{cribben@ualberta.ca}
}
