% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fabric_onelake_read_delta_table.R
\name{fabric_onelake_read_delta_table}
\alias{fabric_onelake_read_delta_table}
\title{Read a Microsoft Fabric/OneLake Delta table (ADLS Gen2)}
\usage{
fabric_onelake_read_delta_table(
  table_path,
  workspace_name,
  lakehouse_name,
  tenant_id = Sys.getenv("FABRICQUERYR_TENANT_ID"),
  client_id = Sys.getenv("FABRICQUERYR_CLIENT_ID", unset =
    "04b07795-8ddb-461a-bbee-02f9e1bf7b46"),
  dest_dir = NULL,
  verbose = TRUE,
  dfs_base = "https://onelake.dfs.fabric.microsoft.com"
)
}
\arguments{
\item{table_path}{Character. Table name or nested path (e.g.
\code{"Patienten"} or \code{"Patienten/patienten_hash"}). Only the last path
segment is used as the table directory under \verb{Tables/}.}

\item{workspace_name}{Character. Fabric workspace display name or GUID
(this is the ADLS filesystem/container name).}

\item{lakehouse_name}{Character. Lakehouse item name, with or without the
\code{.Lakehouse} suffix (e.g. \code{"Lakehouse"} or \code{"Lakehouse.Lakehouse"}).}

\item{tenant_id}{Character. Entra ID (Azure AD) tenant GUID. Defaults to
\code{Sys.getenv("FABRICQUERYR_TENANT_ID")} if missing.}

\item{client_id}{Character. App registration (client) ID. Defaults to
\code{Sys.getenv("FABRICQUERYR_CLIENT_ID")}, falling back to the Azure CLI app id
\code{"04b07795-8ddb-461a-bbee-02f9e1bf7b46"} if not set.}

\item{dest_dir}{Character or \code{NULL}. Local staging directory for Parquet
parts. If \code{NULL} (default), a temp dir is used and cleaned up on exit.}

\item{verbose}{Logical. Print progress messages via \code{{cli}}. Default \code{TRUE}.}

\item{dfs_base}{Character. OneLake DFS endpoint. Default
\code{"https://onelake.dfs.fabric.microsoft.com"}.}
}
\value{
A tibble with the table's current rows (0 rows if the table is empty).
}
\description{
Authenticates to OneLake (ADLS Gen2), resolves the table's
\verb{_delta_log} to determine the \emph{current} active Parquet parts,
downloads only those parts to a local staging directory, and
returns the result as a tibble.
}
\details{
\itemize{
\item In Microsoft Fabric, OneLake exposes each workspace as an ADLS Gen2
filesystem. Within a Lakehouse item, Delta tables are stored under
\verb{Tables/<table>} with a \verb{_delta_log/} directory that tracks commit state.
This helper replays the JSON commits to avoid double-counting
compacted/removed files.
\item Ensure the account/principal you authenticate with has access via
\strong{Lakehouse -> Manage OneLake data access} (or is a member of the workspace).
\item \pkg{AzureAuth} is used to acquire the token. Be wary of
caching behavior; you may want to call \code{\link[AzureAuth:get_azure_token]{AzureAuth::clean_token_directory()}}
to clear cached tokens if you run into issues
}
}
\examples{
# Example is not executed since it requires configured credentials for Fabric
\dontrun{
df <- fabric_onelake_read_delta_table(
  table_path     = "Patients/PatientInfo",
  workspace_name = "PatientsWorkspace",
  lakehouse_name = "Lakehouse.Lakehouse",
  tenant_id      = Sys.getenv("FABRICQUERYR_TENANT_ID"),
  client_id      = Sys.getenv("FABRICQUERYR_CLIENT_ID")
)
dplyr::glimpse(df)
}
}
