# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title PAComponent
#' @description PAComponent Class
#' @format An \code{R6Class} generator object
#' @field id  character [optional]
#'
#' @field accounts  list( \link{PAIdentifier} ) [optional]
#'
#' @field benchmarks  list( \link{PAIdentifier} ) [optional]
#'
#' @field currencyisocode  character [optional]
#'
#' @field dates  \link{PADateParameters} [optional]
#'
#' @field snapshot  character [optional]
#'
#' @field name  character [optional]
#'
#' @field category  character [optional]
#'
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
PAComponent <- R6::R6Class(
  'PAComponent',
  public = list(
    `id` = NULL,
    `accounts` = NULL,
    `benchmarks` = NULL,
    `currencyisocode` = NULL,
    `dates` = NULL,
    `snapshot` = NULL,
    `name` = NULL,
    `category` = NULL,
    initialize = function(`id`=NULL, `accounts`=NULL, `benchmarks`=NULL, `currencyisocode`=NULL, `dates`=NULL, `snapshot`=NULL, `name`=NULL, `category`=NULL, ...){
      local.optional.var <- list(...)
      if (!is.null(`id`)) {
        stopifnot(is.character(`id`), length(`id`) == 1)
        self$`id` <- `id`
      }
      if (!is.null(`accounts`)) {
        stopifnot(is.vector(`accounts`), length(`accounts`) != 0)
        sapply(`accounts`, function(x) stopifnot(R6::is.R6(x)))
        self$`accounts` <- `accounts`
      }
      if (!is.null(`benchmarks`)) {
        stopifnot(is.vector(`benchmarks`), length(`benchmarks`) != 0)
        sapply(`benchmarks`, function(x) stopifnot(R6::is.R6(x)))
        self$`benchmarks` <- `benchmarks`
      }
      if (!is.null(`currencyisocode`)) {
        stopifnot(is.character(`currencyisocode`), length(`currencyisocode`) == 1)
        self$`currencyisocode` <- `currencyisocode`
      }
      if (!is.null(`dates`)) {
        stopifnot(R6::is.R6(`dates`))
        self$`dates` <- `dates`
      }
      if (!is.null(`snapshot`)) {
        self$`snapshot` <- `snapshot`
      }
      if (!is.null(`name`)) {
        stopifnot(is.character(`name`), length(`name`) == 1)
        self$`name` <- `name`
      }
      if (!is.null(`category`)) {
        stopifnot(is.character(`category`), length(`category`) == 1)
        self$`category` <- `category`
      }
    },
    toJSON = function() {
      PAComponentObject <- list()
      if (!is.null(self$`id`)) {
        PAComponentObject[['id']] <-
          self$`id`
      }
      if (!is.null(self$`accounts`)) {
        PAComponentObject[['accounts']] <-
          lapply(self$`accounts`, function(x) x$toJSON())
      }
      if (!is.null(self$`benchmarks`)) {
        PAComponentObject[['benchmarks']] <-
          lapply(self$`benchmarks`, function(x) x$toJSON())
      }
      if (!is.null(self$`currencyisocode`)) {
        PAComponentObject[['currencyisocode']] <-
          self$`currencyisocode`
      }
      if (!is.null(self$`dates`)) {
        PAComponentObject[['dates']] <-
          self$`dates`$toJSON()
      }
      if (!is.null(self$`snapshot`)) {
        PAComponentObject[['snapshot']] <-
          self$`snapshot`
      }
      if (!is.null(self$`name`)) {
        PAComponentObject[['name']] <-
          self$`name`
      }
      if (!is.null(self$`category`)) {
        PAComponentObject[['category']] <-
          self$`category`
      }

      PAComponentObject
    },
    fromJSON = function(PAComponentJson) {
      PAComponentObject <- jsonlite::fromJSON(PAComponentJson)
      if (!is.null(PAComponentObject$`id`)) {
        self$`id` <- PAComponentObject$`id`
      }
      if (!is.null(PAComponentObject$`accounts`)) {
        self$`accounts` <- ApiClient$new()$deserializeObj(PAComponentObject$`accounts`, "array[PAIdentifier]", loadNamespace("factset.analyticsapi.engines"))
      }
      if (!is.null(PAComponentObject$`benchmarks`)) {
        self$`benchmarks` <- ApiClient$new()$deserializeObj(PAComponentObject$`benchmarks`, "array[PAIdentifier]", loadNamespace("factset.analyticsapi.engines"))
      }
      if (!is.null(PAComponentObject$`currencyisocode`)) {
        self$`currencyisocode` <- PAComponentObject$`currencyisocode`
      }
      if (!is.null(PAComponentObject$`dates`)) {
        datesObject <- PADateParameters$new()
        datesObject$fromJSON(jsonlite::toJSON(PAComponentObject$dates, auto_unbox = TRUE, digits = NA))
        self$`dates` <- datesObject
      }
      if (!is.null(PAComponentObject$`snapshot`)) {
        self$`snapshot` <- PAComponentObject$`snapshot`
      }
      if (!is.null(PAComponentObject$`name`)) {
        self$`name` <- PAComponentObject$`name`
      }
      if (!is.null(PAComponentObject$`category`)) {
        self$`category` <- PAComponentObject$`category`
      }
    },
    toJSONString = function() {
      jsoncontent <- c(
        if (!is.null(self$`id`)) {
        sprintf(
        '"id":
          "%s"
                ',
        self$`id`
        )},
        if (!is.null(self$`accounts`)) {
        sprintf(
        '"accounts":
        [%s]
',
        paste(sapply(self$`accounts`, function(x) jsonlite::toJSON(x$toJSON(), auto_unbox=TRUE, digits = NA)), collapse=",")
        )},
        if (!is.null(self$`benchmarks`)) {
        sprintf(
        '"benchmarks":
        [%s]
',
        paste(sapply(self$`benchmarks`, function(x) jsonlite::toJSON(x$toJSON(), auto_unbox=TRUE, digits = NA)), collapse=",")
        )},
        if (!is.null(self$`currencyisocode`)) {
        sprintf(
        '"currencyisocode":
          "%s"
                ',
        self$`currencyisocode`
        )},
        if (!is.null(self$`dates`)) {
        sprintf(
        '"dates":
        %s
        ',
        jsonlite::toJSON(self$`dates`$toJSON(), auto_unbox=TRUE, digits = NA)
        )},
        if (!is.null(self$`snapshot`)) {
        sprintf(
        '"snapshot":
          "%s"
                ',
        self$`snapshot`
        )},
        if (!is.null(self$`name`)) {
        sprintf(
        '"name":
          "%s"
                ',
        self$`name`
        )},
        if (!is.null(self$`category`)) {
        sprintf(
        '"category":
          "%s"
                ',
        self$`category`
        )}
      )
      jsoncontent <- paste(jsoncontent, collapse = ",")
      paste('{', jsoncontent, '}', sep = "")
    },
    fromJSONString = function(PAComponentJson) {
      PAComponentObject <- jsonlite::fromJSON(PAComponentJson)
      self$`id` <- PAComponentObject$`id`
      self$`accounts` <- ApiClient$new()$deserializeObj(PAComponentObject$`accounts`, "array[PAIdentifier]", loadNamespace("factset.analyticsapi.engines"))
      self$`benchmarks` <- ApiClient$new()$deserializeObj(PAComponentObject$`benchmarks`, "array[PAIdentifier]", loadNamespace("factset.analyticsapi.engines"))
      self$`currencyisocode` <- PAComponentObject$`currencyisocode`
      self$`dates` <- PADateParameters$new()$fromJSON(jsonlite::toJSON(PAComponentObject$dates, auto_unbox = TRUE, digits = NA))
      self$`snapshot` <- PAComponentObject$`snapshot`
      self$`name` <- PAComponentObject$`name`
      self$`category` <- PAComponentObject$`category`
      self
    }
  )
)
