% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_matrices.R
\name{group_matrices}
\alias{group_matrices}
\title{Group confusion matrices}
\usage{
group_matrices(protected, probs, preds, cutoff)
}
\arguments{
\item{protected}{vector containing protected variable}

\item{probs}{\code{character} name of column with probabilities}

\item{preds}{numeric, vector with predictions}

\item{cutoff}{\code{numeric} cutoff for probabilities, default = 0.5}
}
\value{
\code{group_matrices} object
It is a list with values:
\itemize{
For each subgroup:
\item subgroup
\itemize{
\item{tp}{ - number of true positives}
\item{fp}{ - number of false positives}
\item{tn}{ - number of true negatives}
\item{fn}{ - number of false negatives}
}}
}
\description{
Calculates confusion matrices for each subgroup
}
\examples{
data("compas")

glm_compas <- glm(Two_yr_Recidivism~., data=compas, family=binomial(link="logit"))
y_prob <- glm_compas$fitted.values

y_numeric <- as.numeric(compas$Two_yr_Recidivism)-1

gm <- group_matrices(compas$Ethnicity,
                     y_prob,
                     y_numeric,
                     cutoff = list(Asian = 0.45,
                     African_American = 0.5,
                     Other = 0.5,
                     Hispanic = 0.5,
                     Caucasian = 0.4,
                     Native_American = 0.5))

gm

}
