% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/falsy-package.r
\name{is_falsy}
\alias{is_falsy}
\title{Is an object FALSY?}
\usage{
is_falsy(object)
}
\arguments{
\item{object}{The object.}
}
\value{
Logical scalar.
}
\description{
Everything that is \code{FALSE} is also \emph{falsy}. Everything that is
\code{TRUE}, is  also \emph{truthy}. Other things are either falsy, or
truthy, see the details below.
}
\details{
Falsy objects are:
\itemize{
 \item \code{NULL}
 \item \code{FALSE}
 \item \code{0L}, integer zero value.
 \item \code{0}, real zero value.
 \item \code{0+0i}, complex zero value.
 \item \code{""}, character scalar that is the empty string.
 \item \code{00}, one byte raw vector with zero value.
 \item Empty vectors. I.e. \code{logical()}, \code{integer()},
       \code{double()}, \code{complex()}, \code{character()}
       and \code{raw()}.
 \item Empty list.
 \item Object from the \code{try-error} class.
}
Everything else is truthy.
}
\examples{
## NULL is falsy
is_falsy(NULL)

## So is the empty string
is_falsy("")

## But the zero string is not
is_falsy("0")

## Clasess are truthy
is_falsy(factor())

## Errors reported by try() are falsy
is_falsy(try(a + "string", silent = TRUE))
}

