% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarS4Classes.R
\docType{class}
\name{familiarHyperparameterLearner-class}
\alias{familiarHyperparameterLearner-class}
\title{Hyperparameter learner.}
\description{
A familiarHyperparameterLearner object is a self-contained model that can be
applied to predict optimisation scores for a set of hyperparameters.
}
\details{
Hyperparameter learners are used to infer the optimisation score for
  sets of hyperparameters. These are then used to either infer utility using
  acquisition functions or to generate summary scores to identify the optimal
  model.
}
\section{Slots}{

\describe{
\item{\code{name}}{Name of the familiarHyperparameterLearner object.}

\item{\code{learner}}{Algorithm used to create the hyperparameter learner.}

\item{\code{target_learner}}{Algorithm for which the hyperparameters are being
learned.}

\item{\code{target_outcome_type}}{Outcome type of the learner for which
hyperparameters are being modeled. Used to determine the target
hyperparameters.}

\item{\code{optimisation_metric}}{One or metrics used to generate the optimisation
score.}

\item{\code{optimisation_function}}{Function used to generate the optimisation score.}

\item{\code{model}}{The actual model trained using the specific algorithm, e.g. a
isolation forest from the `isotree` package.}

\item{\code{target_hyperparameters}}{The names of the hyperparameters that are used
to train the hyperparameter learner.}

\item{\code{project_id}}{Identifier of the project that generated the
familiarHyperparameterLearner object.}

\item{\code{familiar_version}}{Version of the familiar package.}

\item{\code{package}}{Name of package(s) required to executed the hyperparameter
learner itself, e.g. `laGP`.}

\item{\code{package_version}}{Version of the packages mentioned in the `package`
attribute.}
}}

