/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import jfm.lp.ModelPrimitive;
import jfm.model.ELSOptionsComponent;
import jfm.model.Types;

public class ELS
extends ModelPrimitive {
    private final double paymentPerHectare;
    private final double pointsRequiredPerHectare;

    ELS(double paymentPerHectare_, double pointsRequiredPerHectare_) {
        this.paymentPerHectare = paymentPerHectare_;
        this.pointsRequiredPerHectare = pointsRequiredPerHectare_;
    }

    public String name() {
        return "ELS";
    }

    public double isInELS() {
        return this.getSolution()[0];
    }

    public double getAnnualSubsidy() {
        ELSOptionsComponent parent = (ELSOptionsComponent)this.parentComponent;
        return parent.eligibleArea() * this.paymentPerHectare;
    }

    public double getPointsRequirement() {
        ELSOptionsComponent parent = (ELSOptionsComponent)this.parentComponent;
        return parent.eligibleArea() * this.pointsRequiredPerHectare;
    }

    protected void updateStructure(Object caller) {
        this.setCoefficient(Types.ObjectiveType.PROFIT, this.getAnnualSubsidy(), 0);
    }
}

