/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealSolverImpl;
import org.apache.commons.math.analysis.UnivariateRealSolverUtils;

public class BisectionSolver
extends UnivariateRealSolverImpl {
    private static final long serialVersionUID = 4963578633786538912L;

    public BisectionSolver(UnivariateRealFunction f) {
        super(f, 100, 1.0E-6);
    }

    public double solve(double min, double max, double initial) throws MaxIterationsExceededException, FunctionEvaluationException {
        return this.solve(min, max);
    }

    public double solve(double min, double max) throws MaxIterationsExceededException, FunctionEvaluationException {
        this.clearResult();
        this.verifyInterval(min, max);
        for (int i = 0; i < this.maximalIterationCount; ++i) {
            double m = UnivariateRealSolverUtils.midpoint(min, max);
            double fmin = this.f.value(min);
            double fm = this.f.value(m);
            if (fm * fmin > 0.0) {
                min = m;
            } else {
                max = m;
            }
            if (!(Math.abs(max - min) <= this.absoluteAccuracy)) continue;
            m = UnivariateRealSolverUtils.midpoint(min, max);
            this.setResult(m, i);
            return m;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }
}

