% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrate.R
\name{ghQuad}
\alias{ghQuad}
\title{Convenience function for Gauss-Hermite quadrature}
\usage{
ghQuad(f, rule, ...)
}
\arguments{
\item{f}{Function to integrate with respect to first (scalar) argument; this
does not include the weight function \code{exp(-x^2)}}

\item{rule}{Gauss-Hermite quadrature rule to use, as produced by
\code{\link{gaussHermiteData}}}

\item{...}{Additional arguments for f}
}
\value{
Numeric (scalar) with approximation integral of f(x)*exp(-x^2) from
-Inf to Inf.
}
\description{
Convenience function for evaluation of Gauss-Hermite quadrature
}
\details{
This function performs classical unidimensional Gauss-Hermite quadrature
with the function f using the rule provided; that is, it approximates
\deqn{\int_{-\infty}^{\infty} f(x) \exp(-x^2) \, dx}{ integral( f(x)
exp(-x^2), -Inf, Inf)} by evaluating \deqn{ \sum_i w_i f(x_i) }{sum( w *
f(x) )}
}
\examples{

# Get quadrature rules
rule10  <- gaussHermiteData(10)
rule100 <- gaussHermiteData(100)

# Check that rule is implemented correctly
f <- function(x) rep(1,length(x))
if (!isTRUE(all.equal(sqrt(pi), ghQuad(f, rule10), ghQuad(f, rule100)))) {
  print(ghQuad(f, rule10))
  print(ghQuad(f, rule100))
}
# These should be 1.772454

f <- function(x) x
if (!isTRUE(all.equal(0.0, ghQuad(f, rule10), ghQuad(f, rule100)))) {
  print(ghQuad(f, rule10))
  print(ghQuad(f, rule100))
}
# These should be zero


}
\references{
Golub, G. H. and Welsch, J. H. (1969). Calculation of Gauss
Quadrature Rules. Mathematics of Computation 23 (106): 221-230.

Liu, Q. and Pierce, D. A. (1994). A Note on Gauss-Hermite Quadrature.
Biometrika, 81(3) 624-629.
}
\seealso{
\code{\link{gaussHermiteData}}, \code{\link{ghQuad}}
}
\author{
Alexander W Blocker \email{ablocker@gmail.com}
}
\keyword{math}
