% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nameReweight.R
\name{nameReweight}
\alias{nameReweight}
\title{nameReweight}
\usage{
nameReweight(dfA, dfB, EM, gammalist, matchesLink,
varnames, firstname.field, patterns, threshold.match, n.cores)
}
\arguments{
\item{dfA}{The full version of dataset A that is being matched.}

\item{dfB}{The full version of dataset B that is being matched.}

\item{EM}{The EM object from \code{emlinkMARmov()}}

\item{gammalist}{The list of gamma objects calculated on the full
dataset that indicate matching patterns, which is fed into \code{tableCounts()}
and \code{matchesLink()}.}

\item{matchesLink}{The output from \code{matchesLink()}.}

\item{varnames}{A vector of variable names to use for matching.
Must be present in both matchesA and matchesB.}

\item{firstname.field}{A vector of booleans, indicating whether each field indicates
first name. TRUE if so, otherwise FALSE.}

\item{patterns}{The output from \code{getPatterns()}.}

\item{threshold.match}{A number between 0 and 1 indicating either the lower bound (if only one number provided) or the range of certainty that the
user wants to declare a match. For instance, threshold.match = .85 will return all pairs with posterior probability greater than .85 as matches,
while threshold.match = c(.85, .95) will return all pairs with posterior probability between .85 and .95 as matches.}

\item{n.cores}{Number of cores to parallelize over. Default is NULL.}
}
\value{
\code{nameReweight()} returns a list containing the following elements:
\item{zetaA}{The reweighted zeta estimates for each matched element in dataset A.}
\item{zetaB}{The reweighted zeta estimates for each matched element in dataset B.}
}
\description{
Reweights posterior probabilities to account for observed frequency
of names. Downweights posterior probability of match if first name is common,
upweights if first name is uncommon.
}
\author{
Ted Enamorado <ted.enamorado@gmail.com> and Ben Fifield <benfifield@gmail.com>
}
