% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fnb.bernoulli.R, R/fnb.gaussian.R,
%   R/fnb.multinomial.R, R/fnb.train.R
\name{predict.fnb.bernoulli}
\alias{predict.fnb.bernoulli}
\alias{predict.fnb.gaussian}
\alias{predict.fnb.multinomial}
\alias{predict.fastNaiveBayes}
\title{Predict Method for fastNaiveBayes fits}
\usage{
\method{predict}{fnb.bernoulli}(object, newdata, type = c("class", "raw",
  "rawprob"), sparse = FALSE, threshold = .Machine$double.eps,
  check = TRUE, ...)

\method{predict}{fnb.gaussian}(object, newdata, type = c("class", "raw",
  "rawprob"), sparse = FALSE, threshold = .Machine$double.eps,
  check = TRUE, ...)

\method{predict}{fnb.multinomial}(object, newdata, type = c("class",
  "raw", "rawprob"), sparse = FALSE, threshold = .Machine$double.eps,
  check = TRUE, ...)

\method{predict}{fastNaiveBayes}(object, newdata, type = c("class",
  "raw"), sparse = FALSE, threshold = .Machine$double.eps,
  check = TRUE, ...)
}
\arguments{
\item{object}{A fitted object of class "fnb.bernoulli", "fnb.gaussian", "fnb.multinomial" or "fastNaiveBayes".}

\item{newdata}{A numeric matrix. A Sparse dgcMatrix is also accepted.
Note: if fnb.naiveBayes or fnb.gaussian or fnb.train was used to create the model, then if newdata contains features that were not encountered in the training data, these are omitted from the prediction.
Furthermore, newdata can contain fewer features than encountered in the training data. In this case, newdata will be padded with
extra columns all filled with 0's.}

\item{type}{If "raw", the conditional a-posterior probabilities for each class are returned, and the class with maximal probability else.}

\item{sparse}{Use a sparse matrix? If true a sparse matrix will be constructed from x.
It's possible to directly feed a sparse dgcMatrix as x, which will set this parameter to TRUE}

\item{threshold}{A threshold for the minimum probability. For Bernoulli and Multinomial event models Laplace smoothing should solve this,
but in the case of Gaussian event models, this ensures numerical probabilities.}

\item{check}{Whether to perform formal checks on the input. Set to false, if this is not necessary and speed is of the essence}

\item{...}{not used}
}
\value{
If type = 'class', a factor with classified class levels. If type = 'raw', a matrix with the predicted probabilities of
    each class, where each column in the matrix corresponds to a class level.
}
\description{
Uses a fastNaiveBayes model and a new data set to create the classifications.
    This can either be the raw probabilities generated by the fastNaiveBayes model or the classes themselves.
}
\seealso{
\code{\link{fastNaiveBayes}} for the fastNaiveBayes model
}
