% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/demofastcmh.R
\name{demofastcmh}
\alias{demofastcmh}
\title{Demo of fastcmh}
\usage{
demofastcmh(saveToFolder = FALSE, folder = NULL)
}
\arguments{
\item{saveToFolder}{A flag indicating whether or not the data files created
for the demo should be saved to file. The default is \code{FALSE}, i.e. no
files are saved to the folder. The only reason to save demo data to a
folder is for the user to be able to have a look at the files after the
demo.}

\item{folder}{The folder in which the data for the demo will be saved.
Default is the current directory, \code{"./"}. The demo data will created
in \code{folder/data} and the results will be saved in
\code{folder/results} as an RData file.}
}
\description{
This function runs a demo for fastcmh, by first creating a sample data set
and then running fastcmh on this data set.
}
\section{Details}{

This function will first create a sample data set in \code{folder/data},
and will then run \code{runfastcmh} on this data set, before saving the
each step showing the R code that can be used to do the step, then running
that R code, and then waiting for the user to press enter before moving
onto the next step. If \code{saveToFolder=FALSE}, (default) then no files
are saved and all the results are kept in memory.
}

\section{See Also}{

\code{\link{runfastcmh}}
}
\examples{
demofastcmh()
}

