% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd_wrappers.R
\name{fastcpd.lasso}
\alias{fastcpd.lasso}
\alias{fastcpd_lasso}
\title{Find change points efficiently in penalized linear regression models}
\usage{
fastcpd.lasso(data, ...)

fastcpd_lasso(data, ...)
}
\arguments{
\item{data}{A matrix or a data frame with the response variable as the first
column.}

\item{...}{Other arguments passed to \code{\link{fastcpd}}, for example,
\code{segment_count}.}
}
\value{
A class \code{fastcpd} object.
}
\description{
\code{"fastcpd_lasso"} and \code{"fastcpd.lasso"} are wrapper
functions of \code{\link{fastcpd}} to find change points in penalized
linear regression models. The function is similar to \code{"fastcpd"}
except that the data is by default a matrix or data frame with the response
variable as the first column and thus a formula is not required here.
}
\examples{
\donttest{
for (package in c("ggplot2", "mvtnorm")) {
  if (!requireNamespace(package, quietly = TRUE)) utils::install.packages(
    package, repos = "https://cloud.r-project.org", quiet = TRUE
  )
}

set.seed(1)
n <- 480
p_true <- 6
p <- 50
x <- mvtnorm::rmvnorm(n, rep(0, p), diag(p))
theta_0 <- rbind(
  runif(p_true, -5, -2),
  runif(p_true, -3, 3),
  runif(p_true, 2, 5),
  runif(p_true, -5, 5)
)
theta_0 <- cbind(theta_0, matrix(0, ncol = p - p_true, nrow = 4))
y <- c(
  x[1:80, ] \%*\% theta_0[1, ] + rnorm(80, 0, 1),
  x[81:200, ] \%*\% theta_0[2, ] + rnorm(120, 0, 1),
  x[201:320, ] \%*\% theta_0[3, ] + rnorm(120, 0, 1),
  x[321:n, ] \%*\% theta_0[4, ] + rnorm(160, 0, 1)
)
result <- fastcpd.lasso(cbind(y, x), k = function(x) if (x < 30) 1 else 0)
summary(result)
plot(result)
}
}
