% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grassHelp.r
\name{grassHelp}
\alias{grassHelp}
\title{Open the help page for a GRASS module}
\usage{
grassHelp(x, online = FALSE)
}
\arguments{
\item{x}{Character: Any of:
\itemize{
\item The name of a \strong{GRASS} module (e.g., \code{"r.mapcalc"}).
\item \code{"toc"}: \strong{GRASS} manual table of contents.
\item \code{"index"}: Display an index of topics.
}}

\item{online}{Logical: If \code{FALSE} (default), show the manual page that was included with your installation of \strong{GRASS} on your computer.  If \code{FALSE}, show the manual page online (requires an Internet connection). In either case, the manual page will display for the version of \strong{GRASS} you have installed.}
}
\value{
Nothing (opens a web page).
}
\description{
This function opens the manual page for a \strong{GRASS} module (function) in your browser.
}
\examples{
if (grassStarted() & interactive()) {

# Open help pages for `r.mapcalc` and `r.sun`:
grassHelp("r.mapcalc")
grassHelp("r.sun")

# GRASS table of contents:
grassHelp("toc")

# Index page:
grassHelp("index")

}
}
