% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_model.R
\name{process_model}
\alias{process_model}
\title{Process and Evaluate a Model Workflow}
\usage{
process_model(
  model_obj,
  model_id,
  task,
  test_data,
  label,
  event_class,
  engine,
  train_data,
  metric
)
}
\arguments{
\item{model_obj}{A fitted model or a tuning result (`tune_results` object).}

\item{model_id}{A character identifier for the model (used in warnings).}

\item{task}{Type of task, either `"classification"` or `"regression"`.}

\item{test_data}{A data frame containing the test data.}

\item{label}{The name of the outcome variable (as a character string).}

\item{event_class}{For binary classification, specifies which class is considered the positive class:
`"first"` or `"second"`.}

\item{engine}{A character string indicating the model engine (e.g., `"xgboost"`, `"randomForest"`). Used
to determine if class probabilities are supported. If `NULL`, probabilities are skipped.}

\item{train_data}{A data frame containing the training data, required to refit finalized workflows.}

\item{metric}{The name of the metric (e.g., `"roc_auc"`, `"accuracy"`, `"rmse"`) used for selecting the best tuning result.}
}
\value{
A list with two elements:
\describe{
  \item{performance}{A tibble with computed performance metrics.}
  \item{predictions}{A tibble with predicted values and corresponding truth values, and probabilities (if applicable).}
}
}
\description{
This function processes a fitted model or a tuning result, finalizes the model if tuning was used,
makes predictions on the test set, and computes performance metrics depending on the task type
(classification or regression). It supports binary and multiclass classification, and handles
probabilistic outputs when supported by the modeling engine.
}
\details{
- If the input `model_obj` is a `tune_results` object, the function finalizes the model using the
  best hyperparameters according to the specified `metric`, and refits the model on the full training data.

- For classification tasks, performance metrics include accuracy, kappa, sensitivity, specificity, precision,
  F1-score, and ROC AUC (if probabilities are available).

- For regression tasks, RMSE, R-squared, and MAE are returned.

- For models with missing prediction lengths, a helpful imputation error is thrown to guide data preprocessing.
}
