% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/API.R
\name{get_analogies}
\alias{get_analogies}
\title{Get analogy}
\usage{
get_analogies(model, w1, w2, w3, k = 1)
}
\arguments{
\item{model}{trained fastText model. Null if train a new model.}

\item{w1}{1st word, basis}

\item{w2}{2nd word, move}

\item{w3}{3d word, new basis}

\item{k}{number of words to return}
}
\value{
a \link{numeric} with distances and \link{names} are words
}
\description{
From Mikolov paper
Based on related move of a vector regarding a basis.
King is to Quenn what a man is to ???
w1 - w2 + w3
}
\examples{

library(fastrtext)
model_test_path <- system.file("extdata", "model_unsupervised_test.bin", package = "fastrtext")
model <- load_model(model_test_path)
get_analogies(model, "experience", "experiences", "result")

}
