% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/API.R
\name{get_hamming_loss}
\alias{get_hamming_loss}
\title{Hamming loss}
\usage{
get_hamming_loss(labels, predictions)
}
\arguments{
\item{labels}{list of labels}

\item{predictions}{list returned by the predict command (including both the probability and the categories)}
}
\value{
a \code{scalar} with the loss
}
\description{
Compute the hamming loss. When there is only one category, this measure the accuracy.
}
\examples{

library(fastrtext)
data("test_sentences")
model_test_path <- system.file("extdata", "model_classification_test.bin", package = "fastrtext")
model <- load_model(model_test_path)
sentences <- test_sentences[, "text"]
test_labels <- test_sentences[, "class.text"]
predictions <- predict(model, sentences)
get_hamming_loss(as.list(test_labels), predictions)

}
