% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{fastverse_install}
\alias{fastverse_install}
\title{Install (missing) fastverse packages}
\usage{
fastverse_install(..., only.missing = TRUE, install = TRUE)
}
\arguments{
\item{\dots}{comma-separated package names, quoted or unquoted, or vectors of package names. If left empty, all packages returned by \code{\link{fastverse_packages}} are checked.}

\item{only.missing}{logical. \code{TRUE} only installs packages that are unavailable. \code{FALSE} installs all packages, even if they are available.}

\item{install}{logical. \code{TRUE} will proceed to install packages, whereas \code{FALSE} (recommended) will print the installation command asking you to run it in a clean R session.}
}
\value{
\code{fastverse_install} returns \code{NULL} invisibly.
}
\description{
This function (by default) checks if any \emph{fastverse} package is missing and installs the missing package(s).
}
\details{
This function is useful to call before \code{library(fastverse)}, especially in a project when a \code{.fastverse} configuration file is used to load a custom set of packages not natively installed by the \code{fastverse} package (see vignette). 
The idea behind this is that you may customize the \emph{fastverse} for the project, then revisit the project after a long while, and some packages listed in your config file may be missing. 
You can guard against missing packages by running \code{fastverse::fastverse_install()} before \code{library(fastverse)}, to ensure that all \emph{fastverse} packages are available before loading the \emph{fastverse} and executing any code.
}
\seealso{
\code{\link{fastverse_update}}, \code{\link{fastverse}}
}
