% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_concept.R
\name{SparseConcept}
\alias{SparseConcept}
\title{R6 class for a fuzzy concept with sparse internal representation}
\description{
This class implements the data structure and methods for fuzzy concepts.
}
\examples{
# Build a formal context and find its concepts
fc_planets <- FormalContext$new(planets)
fc_planets$find_concepts()

# Print the first three concepts
fc_planets$concepts[1:3]

# Select the first concept:
C <- fc_planets$concepts[1][[1]]

# Get its extent and intent
C$get_extent()
C$get_intent()

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SparseConcept$new()}}
\item \href{#method-get_extent}{\code{SparseConcept$get_extent()}}
\item \href{#method-get_intent}{\code{SparseConcept$get_intent()}}
\item \href{#method-print}{\code{SparseConcept$print()}}
\item \href{#method-to_latex}{\code{SparseConcept$to_latex()}}
\item \href{#method-clone}{\code{SparseConcept$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Creator for objects of class \code{SparseConcept}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SparseConcept$new(extent, intent)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extent}}{(\code{SparseSet}) The extent of the concept.}

\item{\code{intent}}{(\code{SparseSet}) The intent of the concept.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{SparseConcept}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_extent"></a>}}
\subsection{Method \code{get_extent()}}{
Internal \code{SparseSet} for the extent
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SparseConcept$get_extent()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \code{SparseSet} representation of the extent.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_intent"></a>}}
\subsection{Method \code{get_intent()}}{
Internal \code{SparseSet} for the intent
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SparseConcept$get_intent()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \code{SparseSet} representation of the intent.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\subsection{Method \code{print()}}{
Prints the concept to console
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SparseConcept$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A string with the elements of the set and their grades between brackets {}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-to_latex"></a>}}
\subsection{Method \code{to_latex()}}{
Write the concept in LaTeX format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SparseConcept$to_latex()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The fuzzy concept in LaTeX.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SparseConcept$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
