% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/implication_set.R
\name{ImplicationSet}
\alias{ImplicationSet}
\title{R6 Class for Set of implications}
\description{
This class implements the structure needed to store implications and the methods associated.
}
\examples{
# Build a formal context
fc_planets <- FormalContext$new(planets)

# Find its implication basis
fc_planets$find_implications()

# Print implications
fc_planets$implications

# Cardinality and mean size in the ruleset
fc_planets$implications$cardinality()
sizes <- fc_planets$implications$size()
colMeans(sizes)

# Simplify the implication set
fc_planets$implications$apply_rules("simplification")

}
\references{
Hahsler M, Grun B, Hornik K (2005). “arules - a computational environment for mining association rules and frequent item sets.” \emph{J Stat Softw}, \emph{14}, 1-25.

Belohlavek R, Cordero P, Enciso M, Mora Á, Vychodil V (2016). “Automated prover for attribute dependencies in data with grades.” \emph{International Journal of Approximate Reasoning}, \emph{70}, 51-67.

Mora A, Cordero P, Enciso M, Fortes I, Aguilera G (2012). “Closure via functional dependence simplification.” \emph{International Journal of Computer Mathematics}, \emph{89}(4), 510-526.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ImplicationSet$new()}}
\item \href{#method-get_attributes}{\code{ImplicationSet$get_attributes()}}
\item \href{#method-[}{\code{ImplicationSet$[()}}
\item \href{#method-to_arules}{\code{ImplicationSet$to_arules()}}
\item \href{#method-add}{\code{ImplicationSet$add()}}
\item \href{#method-cardinality}{\code{ImplicationSet$cardinality()}}
\item \href{#method-is_empty}{\code{ImplicationSet$is_empty()}}
\item \href{#method-size}{\code{ImplicationSet$size()}}
\item \href{#method-closure}{\code{ImplicationSet$closure()}}
\item \href{#method-recommend}{\code{ImplicationSet$recommend()}}
\item \href{#method-apply_rules}{\code{ImplicationSet$apply_rules()}}
\item \href{#method-to_basis}{\code{ImplicationSet$to_basis()}}
\item \href{#method-print}{\code{ImplicationSet$print()}}
\item \href{#method-to_latex}{\code{ImplicationSet$to_latex()}}
\item \href{#method-get_LHS_matrix}{\code{ImplicationSet$get_LHS_matrix()}}
\item \href{#method-get_RHS_matrix}{\code{ImplicationSet$get_RHS_matrix()}}
\item \href{#method-filter}{\code{ImplicationSet$filter()}}
\item \href{#method-support}{\code{ImplicationSet$support()}}
\item \href{#method-clone}{\code{ImplicationSet$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize with an optional name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{See Details.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Creates and initialize a new \code{FormalContext} object. It can be done in two ways:
\code{initialize(name, attributes, lhs, rhs)}
or \code{initialize(rules)}

In the first way, the only mandatory argument is \code{attributes}, (character vector) which is a vector of names of the attributes on which we define the implications. Optional arguments are: \code{name} (character string), name of the implication set, \code{lhs} (a \code{dgCMatrix}), initial LHS of the implications stored and the analogous \code{rhs}.

The other way is used to initialize the \code{FormalContext} object from a \code{rules} object from package \code{arules}.
}

\subsection{Returns}{
A new \code{ImplicationSet} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_attributes"></a>}}
\if{latex}{\out{\hypertarget{method-get_attributes}{}}}
\subsection{Method \code{get_attributes()}}{
Get the names of the attributes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$get_attributes()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character vector with the names of the attributes used in the implications.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-["></a>}}
\if{latex}{\out{\hypertarget{method-[}{}}}
\subsection{Method \code{[()}}{
Get a subset of the implication set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$[(idx)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{idx}}{(integer or logical vector) Indices of the implications to extract or remove. If logical vector, only \code{TRUE} elements are retained and the rest discarded.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{ImplicationSet} with only the rules given by the \code{idx} indices (if all \code{idx > 0} and all but \code{idx} if all \code{idx < 0}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-to_arules"></a>}}
\if{latex}{\out{\hypertarget{method-to_arules}{}}}
\subsection{Method \code{to_arules()}}{
Convert to arules format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$to_arules(quality = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{quality}}{(logical) Compute the interest measures for each rule?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{rules} object as used by package \code{arules}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add"></a>}}
\if{latex}{\out{\hypertarget{method-add}{}}}
\subsection{Method \code{add()}}{
Add a precomputed implication set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$add(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{An \code{ImplicationSet} object, a \code{rules} object, or a pair \code{lhs}, \code{rhs} of \code{SparseSet} objects or \code{dgCMatrix}. The implications to add to this formal context.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing, just updates the internal \code{implications} field.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cardinality"></a>}}
\if{latex}{\out{\hypertarget{method-cardinality}{}}}
\subsection{Method \code{cardinality()}}{
Cardinality: Number of implications in the set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$cardinality()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The cardinality of the implication set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_empty"></a>}}
\if{latex}{\out{\hypertarget{method-is_empty}{}}}
\subsection{Method \code{is_empty()}}{
Empty set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$is_empty()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if the set of implications is empty, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-size"></a>}}
\if{latex}{\out{\hypertarget{method-size}{}}}
\subsection{Method \code{size()}}{
Size: number of attributes in each of LHS and RHS
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A vector with two components: the number of attributes present in each of the LHS and RHS of each implication in the set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-closure"></a>}}
\if{latex}{\out{\hypertarget{method-closure}{}}}
\subsection{Method \code{closure()}}{
Compute the semantic closure of a fuzzy set with respect to the implication set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$closure(S, reduce = FALSE, verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{S}}{(a \code{SparseSet} object)  Fuzzy set to compute its closure. Use class \code{SparseSet} to build it.}

\item{\code{reduce}}{(logical) Reduce the implications using simplification logic?}

\item{\code{verbose}}{(logical) Show verbose output?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If \code{reduce == FALSE}, the output is a fuzzy set corresponding to the closure of \code{S}. If \code{reduce == TRUE}, a list with two components: \code{closure}, with the closure as above, and \code{implications}, the reduced set of implications.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-recommend"></a>}}
\if{latex}{\out{\hypertarget{method-recommend}{}}}
\subsection{Method \code{recommend()}}{
Generate a recommendation for a subset of the attributes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$recommend(S, attribute_filter)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{S}}{(a vector) Vector with the grades of each attribute (a fuzzy set).}

\item{\code{attribute_filter}}{(character vector) Names of the attributes to get recommendation for.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A fuzzy set describing the values of the attributes in \code{attribute_filter} within the closure of \code{S}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-apply_rules"></a>}}
\if{latex}{\out{\hypertarget{method-apply_rules}{}}}
\subsection{Method \code{apply_rules()}}{
Apply rules to remove redundancies
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$apply_rules(
  rules = c("composition", "generalization"),
  batch_size = 25000L,
  parallelize = FALSE,
  reorder = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rules}}{(character vector) Names of the rules to use. See \code{details}.}

\item{\code{batch_size}}{(integer) If the number of rules is large, apply the rules by batches of this size.}

\item{\code{parallelize}}{(logical) If possible, should we parallelize the computation among different batches?}

\item{\code{reorder}}{(logical) Should the rules be randomly reordered previous to the computation?}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Currently, the implemented rules are \code{"generalization"}, \code{"simplification"}, \code{"reduction"} and \code{"composition"}.
}

\subsection{Returns}{
Nothing, just updates the internal matrices for LHS and RHS.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-to_basis"></a>}}
\if{latex}{\out{\hypertarget{method-to_basis}{}}}
\subsection{Method \code{to_basis()}}{
Convert Implications to Canonical Basis
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$to_basis()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The canonical basis of implications obtained from the current \code{ImplicationSet}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print all implications to text
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A string with all the implications in the set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-to_latex"></a>}}
\if{latex}{\out{\hypertarget{method-to_latex}{}}}
\subsection{Method \code{to_latex()}}{
Export to LaTeX
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$to_latex(
  print = TRUE,
  ncols = 1,
  numbered = TRUE,
  numbers = seq(self$cardinality())
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{print}}{(logical) Print to output?}

\item{\code{ncols}}{(integer) Number of columns for the output.}

\item{\code{numbered}}{(logical) If \code{TRUE} (default), implications will be numbered in the output.}

\item{\code{numbers}}{(vector) If \code{numbered}, use these elements to enumerate the implications. The default is to enumerate 1, 2, ..., but can be changed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A string in LaTeX format that prints nicely all the implications.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_LHS_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-get_LHS_matrix}{}}}
\subsection{Method \code{get_LHS_matrix()}}{
Get internal LHS matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$get_LHS_matrix()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A sparse matrix representing the LHS of the implications in the set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_RHS_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-get_RHS_matrix}{}}}
\subsection{Method \code{get_RHS_matrix()}}{
Get internal RHS matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$get_RHS_matrix()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A sparse matrix representing the RHS of the implications in the set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-filter"></a>}}
\if{latex}{\out{\hypertarget{method-filter}{}}}
\subsection{Method \code{filter()}}{
Filter implications by attributes in LHS and RHS
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$filter(lhs = NULL, rhs = NULL, drop = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lhs}}{(character vector) Names of the attributes to filter the LHS by. If \code{NULL}, no filtering is done on the LHS.}

\item{\code{rhs}}{(character vector) Names of the attributes to filter the RHS by. If \code{NULL}, no filtering is done on the RHS.}

\item{\code{drop}}{(logical) Remove the rest of attributes in RHS?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{ImplicationSet} that is a subset of the current set, only with those rules which has the attributes in \code{lhs} and \code{rhs} in their LHS and RHS, respectively.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-support"></a>}}
\if{latex}{\out{\hypertarget{method-support}{}}}
\subsection{Method \code{support()}}{
Compute support of each implication
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$support()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A vector with the support of each implication
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ImplicationSet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
