% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_fct.R
\name{fct_sub}
\alias{fct_sub}
\title{Reorder Factor Levels Based on Substrings}
\usage{
fct_sub(
  factor_vec,
  start_pos = NULL,
  end_pos = NULL,
  case = FALSE,
  decreasing = FALSE,
  inplace = TRUE
)
}
\arguments{
\item{factor_vec}{A factor vector whose levels are to be reordered.}

\item{start_pos}{Positive integer. The starting position of the substring. If \code{NULL}, starts from the beginning.}

\item{end_pos}{Positive integer. The ending position of the substring. If \code{NULL}, goes to the end of the string.}

\item{case}{Logical. Should the substring comparison be case-sensitive? Default is \code{FALSE}.}

\item{decreasing}{Logical. Should the ordering be decreasing? Default is \code{FALSE}.}

\item{inplace}{Logical. If \code{TRUE}, returns a new factor vector with elements reordered to align with the new levels' order. If \code{FALSE}, returns a new factor vector with only the levels' order adjusted, leaving the data vector's elements' order unchanged. Defaults to \code{FALSE}.}
}
\value{
A factor vector with levels reordered based on the specified substring.
}
\description{
Reorders the levels of a factor vector based on substrings extracted from the factor levels.
}
\examples{
# Example factor vector
factor_vec <- factor(c('Apple', 'banana', 'Cherry', 'date', 'Fig', 'grape'))

# Reorder based on substring from position 2 to 4
fct_sub(factor_vec, start_pos = 2, end_pos = 4)

# Reorder from position 3 to end, case-sensitive
fct_sub(factor_vec, start_pos = 3, case = TRUE)
}
\author{
Kai Guo
}
