% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdata.methods.R
\name{fdata.methods}
\alias{fdata.methods}
\alias{Math.fdata}
\alias{Ops.fdata}
\alias{Summary.fdata}
\alias{split.fdata}
\alias{order.fdata}
\alias{is.fdata}
\title{fdata  S3 Group Generic Functions}
\usage{
\method{Math}{fdata}(x, ...)

\method{Ops}{fdata}(e1, e2 = NULL)

\method{Summary}{fdata}(..., na.rm = FALSE)

\method{split}{fdata}(x, f, drop = FALSE, ...)

order.fdata(y, fdataobj, na.last = TRUE, decreasing = FALSE)

is.fdata(fdataobj)
}
\arguments{
\item{x}{An \code{fdata} object containing values to be divided into groups or an \code{list} of \code{fdata} objects  containing values to be combine by rows in a to be flatten one \code{fdata} object.}

\item{\dots}{Further arguments passed to methods.}

\item{e1, e2}{\code{fdata} class object}

\item{na.rm}{\code{logical}: should missing values be removed?}

\item{f}{a factor in the sense that as.factor(f) defines the grouping, or a list of such factors in which case their interaction is used for the grouping.}

\item{drop}{\code{logical} indicating if levels that do not occur should be dropped (if f is a factor or a list).}

\item{y}{A sequence of numeric, complex, character or logical vectors, all of the same length, or a classed R object.}

\item{fdataobj}{\code{fdata} class object.}

\item{na.last}{for controlling the treatment of NAs. If TRUE, missing values in the data are put last; if FALSE, they are put first; if NA, they are removed; if "keep" they are kept with rank NA.}

\item{decreasing}{\code{logical} Should the sort order be increasing or decreasing?.}
}
\value{
\itemize{ 
\item split.fdata: The value returned from \code{split} is a list of fdata objects 
containing the values for the groups. The components of the list are named by
 the levels of f (after converting to a factor, or if already a factor and 
 drop = TRUE, dropping unused levels).\
 

\item order.fdata:  returns the functional data \code{fdataobj}  w.r.t. a permutation 
which rearranges its first argument into ascending or descending order.
}
}
\description{
fdata Group generic methods defined for four specified groups
of functions, Math, Ops, Summary and Complex.
 
order.fdata and split.fdata: A wrapper for the order and split  function for fdata object.
}
\details{
In \code{order.fdata} the funcional data is ordered w.r.t the sample order of the values of vector.
 
\code{split.fdata} divides the data in the fdata object \code{x} into the groups defined by \code{f}.
}
\examples{
\dontrun{
data(tecator)
absor<-tecator$absorp.fdata
absor2<-fdata.deriv(absor,1)
absor<-absor2[1:5,1:4]
absor2<-absor2[1:5,1:4]
sum(absor)
round(absor,4)
log1<-log(absor)

fdataobj<-fdata(MontrealTemp)
fac<-factor(c(rep(1,len=17),rep(2,len=17)))
a1<-split(fdataobj,fac)
dim(a1[[1]]);dim(a1[[2]])
}

}
\seealso{
See  \link[base]{Summary} and \link[base]{Complex}.
}
\author{
Manuel Febrero Bande and Manuel Oviedo de la Fuente \email{manuel.oviedo@usc.es}
}
\keyword{descriptive}
\keyword{math}
