% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fregre.igls.r
\name{fregre.igls}
\alias{fregre.igls}
\title{Fit of  Functional Generalized Least Squares Model Iteratively}
\usage{
fregre.igls(
  formula,
  data,
  basis.x = NULL,
  basis.b = NULL,
  correlation,
  maxit = 100,
  rn,
  lambda,
  weights = rep(1, n),
  control,
  ...
)
}
\arguments{
\item{formula}{A two-sided linear formula object describing the
model, with the response on the left of a \code{~} operator and the
terms, separated by \code{+} operators, on the right.}

\item{data}{An optional data frame containing the variables named in
\code{model}, \code{correlation}, \code{weights}, and
\code{subset}. By default the variables are taken from the environment
 from which \code{gls} is called.}

\item{basis.x}{List of basis for functional explanatory data estimation.}

\item{basis.b}{List of basis for \eqn{\beta(t)} parameter estimation.}

\item{correlation}{List  describing the  correlation structure. Defaults to 
\code{NULL}, corresponding to uncorrelated errors.
See the following internal functions  for a description and a code example in script file.
\itemize{
\item \code{corUnstruc(x)}, fit an unstrutured correlation.
\item \code{cor.AR(x, order.max = 8, p=1, method = "lm")} fit an Autoregressive Models to Time Series using \code{\link{ar}} function.
\item \code{cor.ARMA(x, p, d = 0, q = 0, method = "lm", order.max = 1)} Fit an ARIMA model to a univariate time series using \code{\link{arima}} function.
\item \code{corExpo(xy,range, method = "euclidean",p=2)} Fit an exponential correlation structure.
}}

\item{maxit}{Number of maximum of interactions.}

\item{rn}{List of Ridge parameter.}

\item{lambda}{List of Roughness penalty parameter.}

\item{weights}{weights}

\item{control}{Control parameters.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
An object of class \code{"fregre.igls"} representing the functional linear model
fit with temporal dependence errors.
Beside, the class(z) is  similar to "fregre.lm" plus the following objects:
\itemize{
 \item{corStruct}{ Fitted  AR or ARIMA model.  }
 }
}
\description{
This function fits iteratively a functional linear model using generalized 
least squares. The errors are allowed to be correlated and/or have unequal variances.  
\enumerate{
 \item Begin with a preliminary estimation of \eqn{\hat{\theta}=\theta_0} (for instance, 
 \eqn{\theta_0=0}). Compute \eqn{\hat{W}}.
\item Estimate \eqn{b_\Sigma =(Z'\hat{W}Z)^{-1}Z'\hat{W}y}
\item Based on the residuals, \eqn{\hat{e}=\left(y-Zb_\Sigma \right)}, update
 \eqn{\hat{\theta}=\rho\left({\hat{e}}\right)} where \eqn{\rho} depends on the 
 dependence structure chosen.
\item Repeats steps 2 and 3 until convergence (small changes in \eqn{b_\Sigma} and/or \eqn{\hat{\theta}}). 
}
}
\examples{
\dontrun{ 
data(tecator)
x=tecator$absorp.fdata
x.d2<-fdata.deriv(x,nderiv=)
tt<-x[["argvals"]]
dataf=as.data.frame(tecator$y)
# plot the response
plot(ts(tecator$y$Fat))
ldata=list("df"=dataf,"x.d2"=x.d2)
res.gls=fregre.igls(Fat~x.d2,data=ldata,
correlation=list("cor.ARMA"=list()),
control=list("p"=1)) 
res.gls
res.gls$corStruct
}
}
\references{
Oviedo de la Fuente, M., Febrero-Bande, M., Pilar Munoz, and
Dominguez, A.  (2018). Predicting seasonal influenza transmission using 
functional regression models with temporal dependence. PloS one, 13(4), e0194250.
\doi{10.1371/journal.pone.0194250}
}
\keyword{models}
\keyword{regression}
