% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConcReg_Lag.R
\name{ConcReg_Lag}
\alias{ConcReg_Lag}
\title{Functional Concurrent Regression with Lag Model}
\usage{
ConcReg_Lag(Y, X, Lag = NULL, optnsY = NULL, optnsX = NULL)
}
\arguments{
\item{Y}{a list which contains functional responses in the form of a list LY and the time points LT at which they are observed (i.e., list(Ly = LY,Lt = LT)).}

\item{X}{a list of lists which contains the observed functional predictors list Lxj and the time points list Ltj at which they are observed. It needs to be of the form \code{list(list(Ly = Lx1,Lt = Lxt1),list(Ly = Lx2,Lt = Lxt2),...)}.}

\item{Lag}{a length \code{length(X)} vector denoting the lags for all predictors.}

\item{optnsY}{a list of options control parameters for the response specified by \code{list(name=value)}. See `Details' in \code{fdapace::FPCA}.}

\item{optnsX}{a list of options control parameters for the predictors specified by \code{list(name=value)}. See `Details' in \code{fdapace::FPCA}.}
}
\value{
A list of the following:
\item{beta0}{a vector of \code{length(workGridY)} representing the fitted \eqn{\beta_0(t)}}
\item{beta}{A matrix for the concurrent regression effects, where rows correspond to different predictors and columns to different time points.}
\item{workGridY}{a vetor representing the working grid for the response.}
\item{Lag}{a vector representing the lags for all predictors}
}
\description{
Functional concurrent regression model with lag for dense functional responses and dense functional predictors.
}
\details{
The functional concurrent regression model with lag is defined as 
\deqn{E[Y(t)|X_1(t), \cdots, X_p(t)] = \beta_0(t) + \sum_{j=1}^p\beta_j(t)X_j(t-Lag[j])} 
For more details we refer to 
\cite{Şentürk, D. and Müller, H.G., (2010). Functional varying coefficient models for longitudinal data. Journal of the American Statistical Association, 105(491), pp.1256-1264.}
}
\examples{
phi1 <- function(t) sin(pi*t / 5) / sqrt(5)
phi2 <- function(t) cos(pi*t / 5) / sqrt(5)
lambdaX <- c(10, 5)
n <- 50
N <- 101
Xi <- matrix(rnorm(2*n), nrow = n, ncol = 2)
denseLt <- list()
denseLy <- list()
t0 <- seq(0, 15, length.out = N)
for (i in 1:n) {
  denseLt[[i]] <- t0
  denseLy[[i]] <- lambdaX[1]*Xi[i, 1]*phi1(t0) + lambdaX[2]*Xi[i, 2]*phi2(t0)
}
denseX0 <- list(Ly = denseLy,Lt = denseLt)

Lag <- c(3)
t0_out <- t0[t0>=max(Lag)]
beta_1 <- function(t) 5*sin(pi*t/10)
beta_0 <- function(t) t^2/2
### functional response Y(t), t in t0_out ### 
denseLt <- list()
denseLy <- list()
for (i in 1:n) {
  denseLt[[i]] <- t0_out
  denseLy[[i]] <- beta_0(t0_out) +  
    denseX0$Ly[[i]][1:length(t0_out)]* beta_1(t0_out) + 
    rnorm(length(t0_out), 0, 0.1) 
}
denseY <- list(Ly = denseLy, Lt = denseLt)
model = ConcReg_Lag(Y=denseY, X=list(X1 = denseX0), Lag=Lag)

print(model$workGridY) # workGrid for Y between 6 to 15
plot(beta_1(model$workGridY)) # workGrid for X1 between 3 to 12 
plot(beta_0(model$workGridY))

plot(model$beta[1,])
plot(model$beta0)
}
\references{
\cite{Şentürk, D. and Müller, H.G., (2010). Functional varying coefficient models for longitudinal data. Journal of the American Statistical Association, 105(491), pp.1256-1264.}
\cite{Yao, F., Müller, H.G., Wang, J.L. (2005). Functional linear regression analysis for longitudinal data. Annals of Statistics 33, 2873--2903.}
\cite{Hall, P., Horowitz, J.L. (2007). Methodology and convergence rates for functional linear regression. The Annals of Statistics, 35(1), 70--91.}
}
