% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BwNN.R
\name{BwNN}
\alias{BwNN}
\title{Minimum bandwidth based on kNN criterion.}
\usage{
BwNN(Lt, k = 3, onlyMean = FALSE, onlyCov = FALSE)
}
\arguments{
\item{Lt}{n-by-1 list of vectors}

\item{k}{number of unique neighbors for cov and mu (default = 3)}

\item{onlyMean}{Indicator to return only the minimum bandwidth for the mean}

\item{onlyCov}{Indicator to return only the minium bandwidth for the covariance}
}
\description{
Input a list of time points Lt, and the number of unique neighbors k and get the minimum bandwidth  garanteeing k unique neighbours.
}
\examples{
tinyGrid = list(c(1,7), c(2,3),  6,  c(2,4), c(4,5))
BwNN(tinyGrid, k = 2) # c(3,2)
}

