\name{SqrtMean}
\alias{SqrtMean}
\title{SRVF transform of warping functions}
\usage{
  SqrtMean(gam)
}
\arguments{
  \item{gam}{matrix (\eqn{N} x \eqn{M}) of \eqn{M} warping
  functions with \eqn{N} samples}
}
\value{
  Returns a list containing \item{mu}{Karcher mean psi
  function} \item{gam_mu}{Karcher mean warping function}
  \item{psi}{srvf of warping functions} \item{vec}{shooting
  vectors}
}
\description{
  This function calculates the srvf of warping functions
  with corresponding shooting vectors
}
\examples{
data("simu_warp")
out = SqrtMean(simu_warp$gam)
}
\references{
  Srivastava, A., Wu, W., Kurtek, S., Klassen, E., Marron,
  J. S., May 2011. Registration of functional data using
  fisher-rao metric, arXiv:1103.3817v2 [math.ST].

  Tucker, J. D., Wu, W., Srivastava, A., Generative Models
  for Function Data using Phase and Amplitude Separation,
  Computational Statistics and Data Analysis (2012),
  10.1016/j.csda.2012.12.001.
}
\keyword{alignment}
\keyword{srvf}

