% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimum.reparam.R
\name{optimum.reparam}
\alias{optimum.reparam}
\title{Align two functions}
\usage{
optimum.reparam(
  Q1,
  T1,
  Q2,
  T2,
  lambda = 0,
  method = "DP",
  w = 0.01,
  f1o = 0,
  f2o = 0
)
}
\arguments{
\item{Q1}{srsf of function 1}

\item{T1}{sample points of function 1}

\item{Q2}{srsf of function 2}

\item{T2}{sample points of function 2}

\item{lambda}{controls amount of warping (default = 0)}

\item{method}{controls which optimization method (default="DP") options are
Dynamic Programming ("DP"), Coordinate Descent ("DP2"), and Riemannian BFGS
("RBFGS")}

\item{w}{controls LRBFGS (default = 0.01)}

\item{f1o}{initial value of f1, vector or scalar depending on q1, defaults to zero}

\item{f2o}{initial value of f2, vector or scalar depending on q1, defaults to zero}
}
\value{
gam warping function
}
\description{
This function aligns two SRSF functions using Dynamic Programming
}
\examples{
data("simu_data")
q = f_to_srvf(simu_data$f,simu_data$time)
gam = optimum.reparam(q[,1],simu_data$time,q[,2],simu_data$time)
}
\references{
Srivastava, A., Wu, W., Kurtek, S., Klassen, E., Marron, J. S.,
 May 2011. Registration of functional data using fisher-rao metric,
 arXiv:1103.3817v2 [math.ST].

Tucker, J. D., Wu, W., Srivastava, A.,
 Generative Models for Function Data using Phase and Amplitude Separation,
 Computational Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.
}
\keyword{alignment}
\keyword{srsf}
