% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperparameters.R
\name{selectrfnumtrees}
\alias{selectrfnumtrees}
\title{Tuning number of trees hyperparameter.
Trains random forests with a range of number of trees so the optimal number can be identified (using the resulting plot) with cross validation}
\usage{
selectrfnumtrees(
  data,
  maxnum = 100,
  title = "",
  showplots = TRUE,
  output_prefix = ""
)
}
\arguments{
\item{data}{Dataset: dataframe containing classification column and all other column features. Both the training and test datasets will be taken from this dataset.}

\item{maxnum}{Maximum number of trees to be considered. All numbers between 1 and maxnum will be considered. Default: 100.}

\item{title}{Title to be used for the resulting boxplot}

\item{showplots}{TRUE if plots should be shown in standard output, FALSE is plots should be saved as jpg files. Default: TRUE.}

\item{output_prefix}{Prefix used for saving plots. If showplots==FALSE then plots are saved here. Otherwise, standard output.}
}
\value{
Dataframe containing test and training accuracy, sensitivity and specificity
}
\description{
Tuning number of trees hyperparameter.
Trains random forests with a range of number of trees so the optimal number can be identified (using the resulting plot) with cross validation
}
\examples{
data = read.csv(paste(system.file('samples/subsamples', package = "feamiR"),'/sample0.csv',sep=''))
data = rbind(head(data,50),tail(data,50))
data$classification = as.factor(data$classification)
data = data[,2:ncol(data)]
selectrfnumtrees(data,5,'RF boxplots')
}
\keyword{forest}
\keyword{hyperparameter}
\keyword{random}
\keyword{tuning}
