% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_best}
\alias{get_best}
\title{Extract the record with the largest index value}
\usage{
get_best(dt, group = NULL)
}
\arguments{
\item{dt}{a data object collected by the projection pursuit guided tour optimisation in the \code{tourr} package}

\item{group}{the variable to label different runs of the optimiser(s)}
}
\value{
a tibble object containing the best basis found by the optimiser(s)
}
\description{
Extract the record with the largest index value
}
\examples{
dplyr::bind_rows(holes_1d_better, holes_1d_geo) \%>\% get_best(group = method)
}
\seealso{
Other get functions: 
\code{\link{get_anchor}()},
\code{\link{get_basis_matrix}()},
\code{\link{get_dir_search}()},
\code{\link{get_interp_last}()},
\code{\link{get_interp}()},
\code{\link{get_interrupt}()},
\code{\link{get_search_count}()},
\code{\link{get_search}()},
\code{\link{get_space_param}()},
\code{\link{get_start}()},
\code{\link{get_theo}()}
}
\concept{get functions}
