% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores-summary.R
\name{score_summary}
\alias{score_summary}
\title{League standings}
\usage{
score_summary(lid = getOption("lid"), old = FALSE, ...)
}
\arguments{
\item{lid}{ESPN League ID, defaults to \code{getOption("lid")}. Use
\verb{options(lid = <League ID>)} to set your league ID; put that line in your
\code{.Rprofile} file to set the option at start up.}

\item{old}{If \code{FALSE} (default), return only the current season's data. If
\code{TRUE}, return a list with all prior seasons.}

\item{...}{Additional API query arguments. Use "week" and "year" as a
shorthand for "ScoringPeriodId" and "seasonId" respectively.}
}
\value{
A tibble (or list) of league members.
}
\description{
Return the current and projected standings, win streak, total wins, losses,
and points scored for and against each team.
}
\examples{
score_summary(lid = 252353)
}
