% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standings.R
\name{league_simulation}
\alias{league_simulation}
\title{League standing simulation}
\usage{
league_simulation(leagueId = ffl_id(), leagueHistory = FALSE, ...)
}
\arguments{
\item{leagueId}{Numeric league ID or ESPN fantasy page URL. Defaults to
\code{getOption("fflr.leagueId")}. Function fails if no ID is found.}

\item{leagueHistory}{logical; Should the \code{leagueHistory} version of the API
be called? If \code{TRUE}, a list of results is returned, with one element for
each historical year of the league.}

\item{...}{Additional queries passed to \code{\link[httr:GET]{httr::GET()}}
(e.g., \code{scoringPeriodId}). Arguments are converted to a named list to be
passed alongside \code{view}.}
}
\value{
A data frame of simulated team standings.
}
\description{
The ESPN algorithm simulates the entire season according to the projection
and matchup schedule to calculate the probability of a team winning their
division and making the playoffs.
}
\examples{
league_simulation(leagueId = "42654852")
}
