% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_elev.R
\name{sp_elev}
\alias{sp_elev}
\title{Allow autoplotting the columns \code{sp} and \code{elev}.}
\usage{
sp_elev(sp, elev = NULL)
}
\arguments{
\item{sp}{A ForestGEO-like dataframe with the column \code{sp}.}

\item{elev}{A ForestGEO-like elevation list or its \code{col} dataframe -- with
the column \code{elev}. The datasets you pass to \code{sp} and \code{elev} should come
from the same forest plot. This is not compulsory but not doing so is most
likely a mistake.}
}
\value{
An S3 object of class 'sp_elev'.
}
\description{
Allow autoplotting the columns \code{sp} and \code{elev}.
}
\examples{
assert_is_installed("fgeo.x")

species_from_luquillo <- fgeo.x::stem5
elevation_from_luquillo <- fgeo.x::elevation

species_elevation <- sp_elev(species_from_luquillo, elevation_from_luquillo)
inherits(species_elevation, "sp_elev")
}
\seealso{
\code{\link[=autoplot.sp_elev]{autoplot.sp_elev()}}.

Other plot functions: 
\code{\link{autoplot.fgeo_habitat}()},
\code{\link{autoplot.sp_elev}()},
\code{\link{autoplot_by_species.sp_elev}()},
\code{\link{elev}()},
\code{\link{plot_dbh_bubbles_by_quadrat}()},
\code{\link{plot_tag_status_by_subquadrat}()},
\code{\link{sp}()}

Other autoplots: 
\code{\link{autoplot.fgeo_habitat}()},
\code{\link{autoplot.sp_elev}()},
\code{\link{elev}()},
\code{\link{sp}()}

Other functions to construct fgeo classes: 
\code{\link{elev}()},
\code{\link{sp}()}

Other functions to plot elevation: 
\code{\link{autoplot.sp_elev}()},
\code{\link{autoplot_by_species.sp_elev}()},
\code{\link{elev}()}

Other functions to plot species: 
\code{\link{autoplot.sp_elev}()},
\code{\link{autoplot_by_species.sp_elev}()},
\code{\link{sp}()}
}
\concept{autoplots}
\concept{functions to construct fgeo classes}
\concept{functions to plot elevation}
\concept{functions to plot species}
\concept{plot functions}
