% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot_by_species.R
\name{autoplot_by_species.sp_elev}
\alias{autoplot_by_species.sp_elev}
\alias{autoplot_by_species.sp}
\title{List plots of species distribution and topography (good for pdf output).}
\usage{
\method{autoplot_by_species}{sp_elev}(object, species = "all",
  fill = "black", shape = 21, point_size = 3, contour_size = 0.5,
  low = "blue", high = "red", hide_color_legend = FALSE,
  bins = NULL, add_elevation_labels = TRUE, label_size = 3,
  label_color = "grey", xyjust = 1, fontface = "italic",
  xlim = NULL, ylim = NULL, custom_theme = NULL, ...)

\method{autoplot_by_species}{sp}(object, species = "all",
  fill = "black", shape = 21, point_size = 3,
  hide_color_legend = FALSE, xlim = NULL, ylim = NULL,
  custom_theme = NULL, ...)
}
\arguments{
\item{object}{An object created with \code{\link[=sp]{sp()}} or \code{\link[=sp_elev]{sp_elev()}}.}

\item{species}{A character vector giving values in the column \code{sp}. The
output will be a list with as many plots as elements in this vector.
The string "all" (default) plots all unique values of \code{sp}.}

\item{fill}{Character; either a color or "sp", which maps each species to a
different color.}

\item{shape}{A number giving point shape (as in \code{\link[graphics:points]{graphics::points()}}). Passed
to \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}.}

\item{point_size}{A number giving point size. Passed to
\code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}.}

\item{contour_size}{A number giving the size of the contour of elevation
lines. Passed to \code{ggplot2::stat_contour()} (see \code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}}).}

\item{low, high}{A string giving a color of the elevation lines representing
low and high elevation.}

\item{hide_color_legend}{Logical; \code{TRUE} hides the color legend.}

\item{bins}{A number giving the number of elevation lines to plot.}

\item{add_elevation_labels}{Logical; \code{FALSE} hides elevation labels.}

\item{label_size, label_color, fontface}{A number (\code{label_size}) or character
string (\code{label_color} and \code{fontface}) giving the size, colour and fontface
of the text labels for the elevation lines.}

\item{xyjust}{A number to adjust the position of the text labels of the
elevation lines.}

\item{xlim, ylim}{A vector of length 2, for example \code{c(0, 500)}, giving the
minimum and maximum limits of the vertical and horizontal coordinates.}

\item{custom_theme}{A valid \code{\link[ggplot2:theme]{ggplot2::theme()}}. \code{NULL} uses the default
theme \code{\link[=theme_default]{theme_default()}}.}

\item{...}{Not used (included for compatibility across methods).}
}
\value{
A list of objects of class "ggplot".
}
\description{
These functions extend \code{\link[=autoplot.sp]{autoplot.sp()}} and \code{\link[=autoplot.elev]{autoplot.elev()}} and return not a
single plot but a list of plots. They are particularly useful if you want to
print a \emph{.pdf} file with one plot per page. They automatically plot the
variables \code{sp} and \code{elev} of a ForestGEO-like dataset of class 'sp' or
'sp_elev'.
\itemize{
\item Create a 'sp' \code{object} with:
}

\preformatted{    object <- sp(DATA-WITH-VARIABLE-sp)
}
\itemize{
\item Create a 'sp_elev' \code{object} with:
}

\preformatted{    object <- sp_elev(DATA-WITH-VARIABLE-sp, DATA-WITH-VARIABLE-elev)
}

See sections \strong{Usage} and \strong{Examples}.
}
\details{
\code{autoplot_by_species(sp_elev(DATA-WITH-VARIABLE-sp)} (without elevation data)
is equivalent to \code{autoplot_by_species(sp(DATA-WITH-VARIABLE-sp))}.

\strong{fgeo.plot} wraps some functions from the \strong{ggplot2} package.
For more control you can use \strong{ggplot2} directly.
}
\examples{
assert_is_installed("fgeo.x")

# Species ---------------------------------------------------------------
# Small dataset with a few species for quick examples
census <- fgeo.x::tree6_3species

# Showing only two species for speed
autoplot_by_species(sp(census))[1:2]

# To print all plots in a .pdf see `?pdf()`
autoplot_by_species(sp(census))

# Species and elevation (optional) ---------------------------------------

# Species and elevation
elevation <- fgeo.x::elevation
autoplot_by_species(sp_elev(census, elevation))
}
\seealso{
\code{\link[=autoplot]{autoplot()}}, \code{\link[=sp]{sp()}}, \code{\link[=sp_elev]{sp_elev()}}.

Other plot functions: \code{\link{autoplot.fgeo_habitat}},
  \code{\link{autoplot.sp_elev}}, \code{\link{elev}},
  \code{\link{plot_dbh_bubbles_by_quadrat}},
  \code{\link{plot_tag_status_by_subquadrat}},
  \code{\link{sp_elev}}, \code{\link{sp}}

Other functions to plot elevation: \code{\link{autoplot.sp_elev}},
  \code{\link{elev}}, \code{\link{sp_elev}}

Other functions to plot species: \code{\link{autoplot.sp_elev}},
  \code{\link{sp_elev}}, \code{\link{sp}}
}
\concept{functions to list plots from different ForestGEO classes}
\concept{functions to plot elevation}
\concept{functions to plot species}
\concept{plot functions}
