% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/driver-utils.R
\name{summarise_posterior}
\alias{summarise_posterior}
\title{Shortcut for summarize variable with quantiles and mean}
\usage{
summarise_posterior(data, var, ...)
}
\arguments{
\item{data}{tidy data frame}

\item{var}{variable name (unquoted) to be summarised}

\item{...}{other expressions to pass to summarise}
}
\value{
data.frame
}
\description{
Shortcut for summarize variable with quantiles and mean
}
\details{
Notation: \code{pX} refers to the \code{X}\% quantile
}
\examples{
d <- data.frame("a"=sample(1:10, 50, TRUE),
                "b"=rnorm(50))

# Summarize posterior for b over grouping of a and also calcuate
# minmum of b (in addition to normal statistics returned)
d <- dplyr::group_by(d, a)
summarise_posterior(d, b, mean.b = mean(b), min=min(b))
}
