#' @title relative.freq
#-----------------------------------------------------------------------------------------------------------------------------------------------#
#' @description Estimate the relative frequency of non-NA pixels.
#' @param x A vector of class \emph{numeric} or an object of class \emph{rasterLayer}.
#' @param na.rm Logical. Should the NA values be excluded. Default is TRUE.
#' @return A \emph{numeric} element or an object of class \emph{RasterLayer}.
#' @details {Estimates the relative frequency of non-NA values.}
#' @seealso \code{\link{mape}}
#' @examples {
#' 
#' x <- c(1, 1, 1, NA, NA, 1, NA)
#' f <- relative.freq(x, na.rm=TRUE)
#' 
#' }
#' @export

#-----------------------------------------------------------------------------------------------------------------------------------------------#
#-----------------------------------------------------------------------------------------------------------------------------------------------#

relative.freq <- function(x, na.rm=TRUE) {

#-----------------------------------------------------------------------------------------------------------------------------------------------#
# 1. check variables
#-----------------------------------------------------------------------------------------------------------------------------------------------#

  if (!is.numeric(x)) {stop('"x" is not a numeric vector')}

#-----------------------------------------------------------------------------------------------------------------------------------------------#
# 2. estimate relative frequency
#-----------------------------------------------------------------------------------------------------------------------------------------------#

  return(sum(!is.na(x)) / length(x))

}
