% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/url.R
\name{get_endpoint_url}
\alias{get_endpoint_url}
\title{Get the URL to a endpoint of Figma API}
\usage{
get_endpoint_url(endpoint = NULL)
}
\arguments{
\item{endpoint}{A single string with the name of the desired endpoint
(needs to be one of the values present in \code{figma::implemented_endpoints}).
Defaults to NULL;}
}
\value{
A string with the URL to the given endpoint, or, a list with all of
  the implemented endpoints;
}
\description{
Get the URL to a endpoint of Figma API
}
\details{
If the function is called without any arguments, \code{get_endpoint_url()}
will output a list with all of the implemented endpoints.

However, the function accepts a single string value with the name of,
a specific endpoint. In this case, \code{get_endpoint_url()} will
output a single string with the endpoint you selected. Is worth
mentioning, that this string must be one of the values present
in \code{figma::implemented_endpoints}.

If the user provided any type of value that does
not fit in this description, the function
will prompt the user with an error message.
}
\examples{
# Returns the URL to the `files` endpoint of Figma API
library(figma)
figma::get_endpoint_url("files")

}
