% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_simple.R
\name{fill.simple}
\alias{fill.simple}
\title{Imputation by Simple Rules}
\usage{
fill.simple(A, method = c("mean", "median", "random"))
}
\arguments{
\item{A}{an \eqn{(n\times p)} partially observed matrix.}

\item{method}{simple rule to fill in the missing entries in a columnwise manner.}
}
\value{
a named list containing \describe{
\item{X}{an \eqn{(n\times p)} matrix after completion.}
}
}
\description{
One of the most simplest ways to fill in the missing entries is
to apply any simple rule for each variable. In this example, we provide
3 options, \code{"mean"}, \code{"median"}, and \code{"random"}. It assumes
that every column has at least one non-missing entries in that for each column,
the rule is applied from the subset of non-missing values.
}
\examples{
## load image data of 'lena128'
data(lena128)

## transform 5\% of entries into missing
A <- aux.rndmissing(lena128, x=0.05)

## apply all three methods#'
fill1 <- fill.simple(A, method="mean")
fill2 <- fill.simple(A, method="median")
fill3 <- fill.simple(A, method="random")

## visualize
par(mfrow=c(2,2), pty="s")
image(A, col=gray((0:100)/100), axes=FALSE, main="original")
image(fill1$X, col=gray((0:100)/100), axes=FALSE, main="method:mean")
image(fill2$X, col=gray((0:100)/100), axes=FALSE, main="method:median")
image(fill3$X, col=gray((0:100)/100), axes=FALSE, main="method:random")

}
\references{
\insertRef{gelman_data_2007}{filling}
}
