% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finbif_occurrence.R
\name{finbif_occurrence}
\alias{finbif_occurrence}
\alias{fb_occurrence}
\title{Download FinBIF occurrence records}
\usage{
finbif_occurrence(
  ...,
  filter,
  select,
  order_by,
  aggregate,
  sample = FALSE,
  n = 10,
  page = 1,
  count_only = FALSE,
  quiet = FALSE,
  cache = getOption("finbif_use_cache"),
  dwc = FALSE,
  date_time_method,
  check_taxa = TRUE,
  on_check_fail = c("warn", "error"),
  tzone = getOption("finbif_tz"),
  locale = getOption("finbif_locale"),
  seed,
  drop_na = FALSE,
  aggregate_counts = TRUE,
  exclude_na = FALSE
)
}
\arguments{
\item{...}{Character vectors or list of character vectors. Taxa of records
to download.}

\item{filter}{List of named character vectors. Filters to apply to records.}

\item{select}{Character vector. Variables to return. If not specified, a
default set of commonly used variables will be used. Use \code{"default_vars"}
as a shortcut for this set. Variables can be deselected by prepending a \code{-}
to the variable name. If only deselects are specified the default set of
variables without the deselection will be returned.}

\item{order_by}{Character vector. Variables to order records by before they
are returned. Most, though not all, variables can be used to order records
before they are returned. Ordering is ascending by default. To return in
descending order append a \code{-} to the front of the variable (e.g.,
\code{"-date_start"}). Default order is \code{"-date_start"} > \code{"-load_data"} >
\code{"reported_name"}.}

\item{aggregate}{Character. If missing, returns full records. If one or more
of \code{"records"}, \code{"species"}, \code{"taxa"}, \code{"events"} or \code{"documents"}
aggregates combinations of the selected variables by counting records,
species, taxa, events or documents. Aggregation by events or documents
cannot be done in combination with any of the other aggregation types.}

\item{sample}{Logical. If \code{TRUE} randomly sample the records from the FinBIF
database.}

\item{n}{Integer. How many records to download/import.}

\item{page}{Integer. Which page of records to start downloading from.}

\item{count_only}{Logical. Only return the number of records available.}

\item{quiet}{Logical. Suppress the progress indicator for multipage
downloads.}

\item{cache}{Logical. Use cached data.}

\item{dwc}{Logical. Use Darwin Core (or Darwin Core style) variable names.}

\item{date_time_method}{Character. Passed to \code{lutz::tz_lookup_coords()} when
\code{date_time} and/or \code{duration} variables have been selected. Default is
\code{"fast"} when  less than 100,000 records are requested and \code{"none"} when
more. Using method \code{"none"} assumes all records are in timezone
"Europe/Helsinki", Use \code{date_time_method = "accurate"} (requires package
\code{sf}) for greater accuracy at the cost of slower computation.}

\item{check_taxa}{Logical. Check first that taxa are in the FinBIF database.
If true only records that match known taxa (have a valid taxon ID) are
returned.}

\item{on_check_fail}{Character. What to do if a taxon is found not valid. One
of \code{"warn"} (default) or \code{"error"}.}

\item{tzone}{Character. If \code{date_time} has been selected the timezone of the
outputted date-time. Defaults to system timezone.}

\item{locale}{Character. One of the supported two-letter ISO 639-1 language
codes. Current supported languages are English, Finnish, Swedish, Russian,
and Sámi (Northern). For data where more than one language is available
the language denoted by \code{locale} will be preferred while falling back to
the other languages in the order indicated above.}

\item{seed}{Integer. Set a seed for randomly sampling records.}

\item{drop_na}{Logical. A vector indicating which columns to check for
missing data. Values recycled to the number of columns. Defaults to all
columns.}

\item{aggregate_counts}{Logical. Should count variables be returned when
using aggregation.}

\item{exclude_na}{Logical. Should records where all selected variables have
non-NA values only be returned.}
}
\value{
A \code{data.frame}. If \code{count_only =  TRUE} an integer.
}
\description{
Download filtered occurrence data from FinBIF as a \code{data.frame}.
}
\examples{
\dontrun{

# Get recent occurrence data for taxon
finbif_occurrence("Cygnus cygnus")

# Specify the number of records
finbif_occurrence("Cygnus cygnus", n = 100)

# Get multiple taxa
finbif_occurrence("Cygnus cygnus", "Ursus arctos")

# Filter the records
finbif_occurrence(
  species = "Cygnus cygnus",
  filter = list(coordinate_accuracy_max = 100)
)

}
}
