% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findInFiles.R
\name{findInFiles}
\alias{findInFiles}
\title{Find pattern in files}
\usage{
findInFiles(
  ext,
  pattern,
  depth = NULL,
  wholeWord = FALSE,
  ignoreCase = FALSE,
  perl = FALSE,
  excludePattern = NULL,
  excludeFoldersPattern = NULL,
  root = ".",
  output = "viewer"
)
}
\arguments{
\item{ext}{file extension, e.g. \code{"R"} or \code{"js"}}

\item{pattern}{pattern to search for, a regular expression, e.g.
\code{"function"} or \code{"^function"}}

\item{depth}{depth of the search, \code{NULL} or a negative number for an
entire recursive search (subdirectories, subdirectories of subdirectories,
etc.), otherwise a positive integer: \code{0} to search in the root
directory only, \code{1} to search in the root directory and its
subdirectories, etc.}

\item{wholeWord}{logical, whether to match the whole pattern}

\item{ignoreCase}{logical, whether to ignore the case}

\item{perl}{logical, whether \code{pattern} is a Perl regular expression}

\item{excludePattern}{a pattern; exclude from search the files and folders
which match this pattern}

\item{excludeFoldersPattern}{a pattern; exclude from search the folders
which match this pattern}

\item{root}{path to the root directory to search from}

\item{output}{one of \code{"viewer"}, \code{"tibble"} or
\code{"viewer+tibble"}; see examples}
}
\value{
A tibble if \code{output="tibble"}, otherwise a
  \code{htmlwidget} object.
}
\description{
Find a pattern in some files.
}
\examples{
library(findInFiles)
folder <- system.file("example", package = "findInFiles")
findInFiles("R", "function", root = folder)

findInFiles("R", "function", root = folder, output = "tibble")

fif <- findInFiles("R", "function", root = folder, output = "viewer+tibble")
FIF2tibble(fif)
FIF2dataframe(fif)
fif

folder <- system.file("www", "shared", package = "shiny")
findInFiles("css", "outline", excludePattern = "*.min.css", root = folder)
}
