% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/area_types.R
\name{category_types}
\alias{category_types}
\title{Category types}
\usage{
category_types(path)
}
\arguments{
\item{path}{String; Fingertips API address. Function will default to the
correct address}
}
\value{
A data frame of category type ids and their descriptions
}
\description{
Outputs a data frame of category type ids, their name (along with a short name)
}
\examples{
\dontrun{
# Returns the deprivation category types
cats <- category_types()
cats[cats$CategoryTypeId == 1,]}
}
\seealso{
\code{\link{indicators}} for indicator lookups,
  \code{\link{profiles}} for profile lookups,
  \code{\link{deprivation_decile}} for deprivation decile lookups,
  \code{\link{area_types}} for area type lookups,
  \code{\link{indicator_areatypes}} for indicators by area types lookups,
  \code{\link{indicators_unique}} for unique indicatorids and their names,
  \code{\link{nearest_neighbours}} for a vector of nearest neighbours for an area and
  \code{\link{indicator_order}} for the order indicators are presented on the
  Fingertips website within a Domain

Other lookup functions: 
\code{\link{area_types}()},
\code{\link{deprivation_decile}()},
\code{\link{indicator_areatypes}()},
\code{\link{indicator_metadata}()},
\code{\link{indicator_order}()},
\code{\link{indicators_unique}()},
\code{\link{indicators}()},
\code{\link{nearest_neighbours}()},
\code{\link{profiles}()}
}
\concept{lookup functions}
