% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_comparison_functions.R
\name{fst_comparison_cloud}
\alias{fst_comparison_cloud}
\title{Make comparison cloud}
\usage{
fst_comparison_cloud(
  data1,
  data2,
  data3 = NULL,
  data4 = NULL,
  name1 = "Group 1",
  name2 = "Group 2",
  name3 = "Group 3",
  name4 = "Group 4",
  pos_filter = NULL,
  max = 100
)
}
\arguments{
\item{data1}{A dataframe of text in CoNLL-U format for the first group.}

\item{data2}{A dataframe of text in CoNLL-U format for the second group.}

\item{data3}{An optional dataframe of text in CoNLL-U format for the third
group, default is `NULL`.}

\item{data4}{An optional dataframe of text in CoNLL-U format for the fourth
group, default is `NULL`.}

\item{name1}{A string describing data1, default is `Group 1`.}

\item{name2}{A string describing data2, default is `Group 2`.}

\item{name3}{A string describing data3, default is `Group 3`.}

\item{name4}{A string describing data4, default is `Group 4`.}

\item{pos_filter}{List of UPOS tags for inclusion, default is `NULL` which
means all word types included.}

\item{max}{The maximum number of words to display, default is `100`.}
}
\value{
A comparison cloud from wordcloud package.
}
\description{
Creates a comparison wordcloud showing words that occur differently between
each group.
}
\examples{
d1 <- conllu_dev_q11_1_nltk
d2 <- conllu_dev_q11_3_nltk
pf1 <- c("NOUN", "VERB", "ADJ", "ADV")
fst_comparison_cloud(d1, d2, pos_filter = pf1)

f <- conllu_dev_q11_1_f_nltk
m <- conllu_dev_q11_1_m_nltk
na <- conllu_dev_q11_1_na_nltk
n1 <- "Female"
n2 <- "Male"
n3 <- "NA"
fst_comparison_cloud(f, m, na, name1 = n1, name2 = n2, name3 = n3, max = 400)
fst_comparison_cloud(f, m, na, name1 = n1, name2 = n2, name3 = n3, max = 100)
}
